/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESBoolean;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Data.ObjectObject;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.EcmaScriptParseException;
import FESI.Extensions.BasicIOInterface;
import FESI.Extensions.Extension;
import FESI.Interpreter.Evaluator;
import FESI.awtgui.AwtConfirmationBox;
import FESI.awtgui.AwtMessageBox;
import FESI.awtgui.AwtPromptBox;
import java.io.File;

public class BasicIOw
extends Extension
implements BasicIOInterface {
    private Evaluator evaluator = null;
    private ESObject document = null;
    private ESObject window = null;

    public ESObject getDocument() {
        return this.document;
    }

    public void initializeExtension(Evaluator evaluator) throws EcmaScriptException {
        this.evaluator = evaluator;
        GlobalObject go = evaluator.getGlobalObject();
        this.document = ObjectObject.createObject(evaluator);
        this.window = ObjectObject.createObject(evaluator);
        FunctionPrototype fp = (FunctionPrototype)evaluator.getFunctionPrototype();
        go.putHiddenProperty("document", this.document);
        this.document.putHiddenProperty("write", new GlobalObjectWrite("write", evaluator, fp));
        this.document.putHiddenProperty("writeln", new GlobalObjectWriteln("writeln", evaluator, fp));
        this.document.putHiddenProperty("open", new GlobalObjectNoop("open", evaluator, fp));
        this.document.putHiddenProperty("close", new GlobalObjectNoop("close", evaluator, fp));
        this.document.putHiddenProperty("URL", new ESString("file://<unknown>"));
        go.putHiddenProperty("window", this.window);
        this.window.putHiddenProperty("alert", new GlobalObjectAlert("alert", evaluator, fp));
        this.window.putHiddenProperty("prompt", new GlobalObjectPrompt("prompt", evaluator, fp));
        this.window.putHiddenProperty("confirm", new GlobalObjectConfirm("confirm", evaluator, fp));
        go.putHiddenProperty("write", new GlobalObjectWrite("write", evaluator, fp));
        go.putHiddenProperty("writeln", new GlobalObjectWriteln("writeln", evaluator, fp));
        go.putHiddenProperty("alert", new GlobalObjectAlert("alert", evaluator, fp));
        go.putHiddenProperty("prompt", new GlobalObjectPrompt("prompt", evaluator, fp));
        go.putHiddenProperty("confirm", new GlobalObjectConfirm("confirm", evaluator, fp));
        go.putHiddenProperty("exit", new GlobalObjectExit("exit", evaluator, fp));
        go.putHiddenProperty("load", new GlobalObjectLoad("load", evaluator, fp));
    }

    class GlobalObjectLoad
    extends BuiltinFunctionObject {
        GlobalObjectLoad(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESValue value;
            String fileName = null;
            if (arguments.length > 0) {
                fileName = arguments[0].toString();
            }
            if (fileName == null) {
                throw new EcmaScriptException("Missing file name for load");
            }
            File file = new File(fileName);
            try {
                value = this.evaluator.evaluateLoadModule(fileName);
            }
            catch (EcmaScriptParseException e) {
                e.setNeverIncomplete();
                throw e;
            }
            return value;
        }
    }

    class GlobalObjectNoop
    extends BuiltinFunctionObject {
        GlobalObjectNoop(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            return ESUndefined.theUndefined;
        }
    }

    class GlobalObjectExit
    extends BuiltinFunctionObject {
        GlobalObjectExit(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            int status = 0;
            if (arguments.length > 0) {
                status = arguments[0].toInt32();
            }
            System.exit(status);
            return null;
        }
    }

    class GlobalObjectConfirm
    extends BuiltinFunctionObject {
        GlobalObjectConfirm(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < arguments.length; ++i) {
                sb.append(arguments[i].toString());
            }
            AwtConfirmationBox mb = new AwtConfirmationBox("EcmaScript Confirm", sb.toString());
            boolean response = mb.waitYesOrNo();
            return ESBoolean.makeBoolean(response);
        }
    }

    class GlobalObjectPrompt
    extends BuiltinFunctionObject {
        GlobalObjectPrompt(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            String prompt = "";
            String defaultResponse = "";
            if (arguments.length > 0) {
                prompt = arguments[0].toString();
            }
            if (arguments.length > 1) {
                defaultResponse = arguments[1].toString();
            }
            AwtPromptBox pb = new AwtPromptBox("EcmaScript promt", prompt, defaultResponse);
            return new ESString(pb.waitResponse());
        }
    }

    class GlobalObjectAlert
    extends BuiltinFunctionObject {
        GlobalObjectAlert(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < arguments.length; ++i) {
                sb.append(arguments[i].toString());
            }
            AwtMessageBox mb = new AwtMessageBox("EcmaScript Alert", sb.toString());
            mb.waitOK();
            return ESUndefined.theUndefined;
        }
    }

    class GlobalObjectWriteln
    extends BuiltinFunctionObject {
        GlobalObjectWriteln(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            for (int i = 0; i < arguments.length; ++i) {
                System.out.print(arguments[i].toString());
            }
            System.out.println();
            return ESUndefined.theUndefined;
        }
    }

    class GlobalObjectWrite
    extends BuiltinFunctionObject {
        GlobalObjectWrite(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            for (int i = 0; i < arguments.length; ++i) {
                System.out.print(arguments[i].toString());
            }
            return ESUndefined.theUndefined;
        }
    }
}

