/*
 * Decompiled with CFR 0.152.
 */
package FESI.Exceptions;

import FESI.Interpreter.EvaluationSource;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;

public class EcmaScriptException
extends Exception {
    protected static String eol = System.getProperty("line.separator", "\n");
    protected Vector evaluationSources = new Vector();
    private Throwable originatingException = null;

    public EcmaScriptException(String reason) {
        super(reason);
    }

    public EcmaScriptException(String reason, Throwable originatingException) {
        super(reason);
        this.originatingException = originatingException;
    }

    public Throwable getOriginatingException() {
        return this.originatingException;
    }

    public void appendEvaluationSource(EvaluationSource es) {
        this.evaluationSources.addElement(es);
    }

    public int getLineNumber() {
        if (this.evaluationSources.size() > 0) {
            EvaluationSource es = (EvaluationSource)this.evaluationSources.elementAt(0);
            return es.getLineNumber();
        }
        return -1;
    }

    public String getMessage() {
        String msg = "Runtime error " + super.getMessage();
        if (this.originatingException != null) {
            msg = msg + eol + "Caused by exception: " + eol + "  " + this.originatingException.getMessage();
        }
        if (this.originatingException != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.originatingException.printStackTrace(pw);
            msg = msg + eol;
            pw.close();
            msg = msg + sw.toString();
        }
        for (int i = 0; i < this.evaluationSources.size(); ++i) {
            EvaluationSource es = (EvaluationSource)this.evaluationSources.elementAt(i);
            msg = msg + eol + (i == 0 ? "detected " : "called ") + es;
        }
        return msg;
    }

    public boolean isIncomplete() {
        return false;
    }

    public void printStackTrace() {
        System.err.println(this);
        this.printStackTrace0(new PrintWriter(System.err));
    }

    public void printStackTrace(PrintStream s) {
        s.println(this);
        PrintWriter w = new PrintWriter(s);
        this.printStackTrace0(w);
    }

    public void printStackTrace(PrintWriter w) {
        w.println(this);
        this.printStackTrace0(w);
    }

    private void printStackTrace0(PrintWriter w) {
        super.printStackTrace(w);
        if (this.originatingException != null) {
            w.println("due to:");
            this.originatingException.printStackTrace(w);
        }
        w.flush();
    }
}

