/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ArrayPrototype;
import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.ObjectPrototype;
import FESI.Data.StringPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;

public class StringObject
extends BuiltinFunctionObject {
    private StringObject(ESObject prototype, Evaluator evaluator) {
        super(prototype, evaluator, "String", 1);
    }

    public String toString() {
        return "<String>";
    }

    public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        if (arguments.length == 0) {
            return new ESString("");
        }
        return new ESString(arguments[0].toString());
    }

    public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        StringPrototype theObject = null;
        ESObject sp = this.evaluator.getStringPrototype();
        theObject = new StringPrototype(sp, this.evaluator);
        theObject.value = arguments.length > 0 ? new ESString(arguments[0].toString()) : new ESString("");
        return theObject;
    }

    public static StringObject makeStringObject(Evaluator evaluator, ObjectPrototype objectPrototype, FunctionPrototype functionPrototype) {
        StringPrototype stringPrototype = new StringPrototype(objectPrototype, evaluator);
        StringObject stringObject = new StringObject(functionPrototype, evaluator);
        try {
            stringObject.putHiddenProperty("prototype", stringPrototype);
            stringObject.putHiddenProperty("length", new ESNumber(1.0));
            class StringObjectFromCharCode
            extends BuiltinFunctionObject {
                StringObjectFromCharCode(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    ESObject sp = this.evaluator.getStringPrototype();
                    StringPrototype theObject = new StringPrototype(sp, this.evaluator);
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < arguments.length; ++i) {
                        char c = (char)arguments[i].toUInt16();
                        sb.append(c);
                    }
                    theObject.value = new ESString(sb.toString());
                    return theObject;
                }
            }
            stringObject.putHiddenProperty("fromCharCode", new StringObjectFromCharCode("fromCharCode", evaluator, functionPrototype));
            stringPrototype.putHiddenProperty("constructor", stringObject);
            class StringPrototypeToString
            extends BuiltinFunctionObject {
                StringPrototypeToString(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    return ((StringPrototype)thisObject).value;
                }
            }
            stringPrototype.putHiddenProperty("toString", new StringPrototypeToString("toString", evaluator, functionPrototype));
            class StringPrototypeValueOf
            extends BuiltinFunctionObject {
                StringPrototypeValueOf(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    return ((StringPrototype)thisObject).value;
                }
            }
            stringPrototype.putHiddenProperty("valueOf", new StringPrototypeValueOf("valueOf", evaluator, functionPrototype));
            class StringPrototypeCharAt
            extends BuiltinFunctionObject {
                StringPrototypeCharAt(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    String str = thisObject.toString();
                    int pos = 0;
                    if (arguments.length > 0) {
                        pos = arguments[0].toInt32();
                    }
                    if (pos >= 0 && pos < str.length()) {
                        char[] c = new char[]{str.charAt(pos)};
                        return new ESString(new String(c));
                    }
                    return new ESString("");
                }
            }
            stringPrototype.putHiddenProperty("charAt", new StringPrototypeCharAt("charAt", evaluator, functionPrototype));
            class StringPrototypeCharCodeAt
            extends BuiltinFunctionObject {
                StringPrototypeCharCodeAt(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    String str = thisObject.toString();
                    int pos = 0;
                    if (arguments.length > 0) {
                        pos = arguments[0].toInt32();
                    }
                    if (pos >= 0 && pos < str.length()) {
                        char c = str.charAt(pos);
                        return new ESNumber(c);
                    }
                    return new ESNumber(Double.NaN);
                }
            }
            stringPrototype.putHiddenProperty("charCodeAt", new StringPrototypeCharCodeAt("charCodeAt", evaluator, functionPrototype));
            class StringPrototypeIndexOf
            extends BuiltinFunctionObject {
                StringPrototypeIndexOf(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    String str = thisObject.toString();
                    int pos = 0;
                    if (arguments.length <= 0) {
                        return new ESNumber(-1.0);
                    }
                    String searched = arguments[0].toString();
                    if (arguments.length > 1) {
                        pos = arguments[1].toInt32();
                    }
                    int res = str.indexOf(searched, pos);
                    return new ESNumber(res);
                }
            }
            stringPrototype.putHiddenProperty("indexOf", new StringPrototypeIndexOf("indexOf", evaluator, functionPrototype));
            class StringPrototypeLastIndexOf
            extends BuiltinFunctionObject {
                StringPrototypeLastIndexOf(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    double p;
                    String str = thisObject.toString();
                    int pos = str.length();
                    if (arguments.length <= 0) {
                        return new ESNumber(-1.0);
                    }
                    String searched = arguments[0].toString();
                    if (arguments.length > 1 && !Double.isNaN(p = arguments[1].doubleValue())) {
                        pos = arguments[1].toInt32();
                    }
                    int res = str.lastIndexOf(searched, pos);
                    return new ESNumber(res);
                }
            }
            stringPrototype.putHiddenProperty("lastIndexOf", new StringPrototypeLastIndexOf("lastIndexOf", evaluator, functionPrototype));
            class StringPrototypeSplit
            extends BuiltinFunctionObject {
                StringPrototypeSplit(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    String str = thisObject.toString();
                    ESObject ap = this.evaluator.getArrayPrototype();
                    ArrayPrototype theArray = new ArrayPrototype(ap, this.evaluator);
                    if (arguments.length <= 0) {
                        theArray.setSize(1);
                        theArray.setElementAt(thisObject, 0);
                    } else {
                        String sep = arguments[0].toString();
                        if (sep.length() == 0) {
                            int l = str.length();
                            theArray.setSize(l);
                            for (int i = 0; i < l; ++i) {
                                theArray.setElementAt(new ESString(str.substring(i, i + 1)), i);
                            }
                        } else {
                            int i = 0;
                            int start = 0;
                            while (start < str.length()) {
                                int pos = str.indexOf(sep, start);
                                if (pos < 0) {
                                    pos = str.length();
                                }
                                theArray.setSize(i + 1);
                                theArray.setElementAt(new ESString(str.substring(start, pos)), i);
                                start = pos + sep.length();
                                ++i;
                            }
                        }
                    }
                    return theArray;
                }
            }
            stringPrototype.putHiddenProperty("split", new StringPrototypeSplit("split", evaluator, functionPrototype));
            class StringPrototypeSubstring
            extends BuiltinFunctionObject {
                StringPrototypeSubstring(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    String str = thisObject.toString();
                    int start = 0;
                    int end = str.length();
                    if (arguments.length > 0) {
                        start = arguments[0].toInt32();
                    }
                    if (start < 0) {
                        start = 0;
                    } else if (start > str.length()) {
                        start = str.length();
                    }
                    if (arguments.length > 1) {
                        end = arguments[1].toInt32();
                        if (end < 0) {
                            end = 0;
                        } else if (end > str.length()) {
                            end = str.length();
                        }
                    }
                    if (start > end) {
                        int x = start;
                        start = end;
                        end = x;
                    }
                    return new ESString(str.substring(start, end));
                }
            }
            stringPrototype.putHiddenProperty("substring", new StringPrototypeSubstring("substring", evaluator, functionPrototype));
            class StringPrototypeSubstr
            extends BuiltinFunctionObject {
                StringPrototypeSubstr(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    String str = thisObject.toString();
                    int start = 0;
                    if (arguments.length > 0) {
                        start = arguments[0].toInt32();
                    }
                    int len = Integer.MAX_VALUE;
                    if (arguments.length > 1) {
                        len = arguments[1].toInt32();
                    }
                    if (start < 0 && (start = str.length() + start) < 0) {
                        start = 0;
                    }
                    if (len < 0) {
                        len = 0;
                    }
                    if (str.length() - start < len) {
                        len = str.length() - start;
                    }
                    if (len <= 0) {
                        return new ESString("");
                    }
                    return new ESString(str.substring(start, start + len));
                }
            }
            stringPrototype.putHiddenProperty("substr", new StringPrototypeSubstr("substr", evaluator, functionPrototype));
            class StringPrototypeToLowerCase
            extends BuiltinFunctionObject {
                StringPrototypeToLowerCase(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    String str = thisObject.toString();
                    return new ESString(str.toLowerCase());
                }
            }
            stringPrototype.putHiddenProperty("toLowerCase", new StringPrototypeToLowerCase("toLowerCase", evaluator, functionPrototype));
            class StringPrototypeToUpperCase
            extends BuiltinFunctionObject {
                StringPrototypeToUpperCase(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    String str = thisObject.toString();
                    return new ESString(str.toUpperCase());
                }
            }
            stringPrototype.putHiddenProperty("toUpperCase", new StringPrototypeToUpperCase("toUpperCase", evaluator, functionPrototype));
        }
        catch (EcmaScriptException e) {
            e.printStackTrace();
            throw new ProgrammingError(e.getMessage());
        }
        evaluator.setStringPrototype(stringPrototype);
        return stringObject;
    }
}

