/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;

public class MathObject
extends ObjectPrototype {
    private FunctionPrototype fp;

    private MathObject(ESObject prototype, Evaluator evaluator, FunctionPrototype functionPrototype) throws EcmaScriptException {
        super(prototype, evaluator);
        this.putHiddenProperty("E", new ESNumber(Math.E));
        this.putHiddenProperty("LN10", new ESNumber(Math.log(10.0)));
        this.putHiddenProperty("LN2", new ESNumber(Math.log(2.0)));
        this.putHiddenProperty("LOG2E", new ESNumber(1.0 / Math.log(2.0)));
        this.putHiddenProperty("LOG10E", new ESNumber(1.0 / Math.log(10.0)));
        this.putHiddenProperty("PI", new ESNumber(Math.PI));
        this.putHiddenProperty("SQRT1_2", new ESNumber(1.0 / Math.sqrt(2.0)));
        this.putHiddenProperty("SQRT2", new ESNumber(Math.sqrt(2.0)));
        this.putHiddenProperty("abs", new BuiltinMathFunctionOne("abs", evaluator, functionPrototype){

            public double applyMathFunction(double arg) {
                return Math.abs(arg);
            }
        });
        this.putHiddenProperty("acos", new BuiltinMathFunctionOne("acos", evaluator, functionPrototype){

            public double applyMathFunction(double arg) {
                return Math.acos(arg);
            }
        });
        this.putHiddenProperty("asin", new BuiltinMathFunctionOne("asin", evaluator, functionPrototype){

            public double applyMathFunction(double arg) {
                return Math.asin(arg);
            }
        });
        this.putHiddenProperty("atan", new BuiltinMathFunctionOne("atan", evaluator, functionPrototype){

            public double applyMathFunction(double arg) {
                return Math.atan(arg);
            }
        });
        this.putHiddenProperty("atan2", new BuiltinMathFunctionTwo("atan2", evaluator, functionPrototype){

            public double applyMathFunction(double arg1, double arg2) {
                return Math.atan2(arg1, arg2);
            }
        });
        this.putHiddenProperty("ceil", new BuiltinMathFunctionOne("ceil", evaluator, functionPrototype){

            public double applyMathFunction(double arg) {
                return Math.ceil(arg);
            }
        });
        this.putHiddenProperty("cos", new BuiltinMathFunctionOne("cos", evaluator, functionPrototype){

            public double applyMathFunction(double arg) {
                return Math.cos(arg);
            }
        });
        this.putHiddenProperty("exp", new BuiltinMathFunctionOne("exp", evaluator, functionPrototype){

            public double applyMathFunction(double arg) {
                return Math.exp(arg);
            }
        });
        this.putHiddenProperty("floor", new BuiltinMathFunctionOne("floor", evaluator, functionPrototype){

            public double applyMathFunction(double arg) {
                return Math.floor(arg);
            }
        });
        this.putHiddenProperty("log", new BuiltinMathFunctionOne("log", evaluator, functionPrototype){

            public double applyMathFunction(double arg) {
                return Math.log(arg);
            }
        });
        this.putHiddenProperty("max", new BuiltinMathFunctionTwo("max", evaluator, functionPrototype){

            public double applyMathFunction(double arg1, double arg2) {
                return Math.max(arg1, arg2);
            }
        });
        this.putHiddenProperty("min", new BuiltinMathFunctionTwo("min", evaluator, functionPrototype){

            public double applyMathFunction(double arg1, double arg2) {
                return Math.min(arg1, arg2);
            }
        });
        this.putHiddenProperty("pow", new BuiltinMathFunctionTwo("pow", evaluator, functionPrototype){

            public double applyMathFunction(double arg1, double arg2) {
                double d = Double.NaN;
                try {
                    d = Math.pow(arg1, arg2);
                }
                catch (ArithmeticException e) {
                    // empty catch block
                }
                return d;
            }
        });
        this.putHiddenProperty("random", new BuiltinMathFunctionZero("random", evaluator, functionPrototype){

            public double applyMathFunction() {
                return Math.random();
            }
        });
        this.putHiddenProperty("round", new BuiltinMathFunctionOne("round", evaluator, functionPrototype){

            public double applyMathFunction(double arg) {
                return Math.round(arg);
            }
        });
        this.putHiddenProperty("sin", new BuiltinMathFunctionOne("sin", evaluator, functionPrototype){

            public double applyMathFunction(double arg) {
                return Math.sin(arg);
            }
        });
        this.putHiddenProperty("sqrt", new BuiltinMathFunctionOne("sqrt", evaluator, functionPrototype){

            public double applyMathFunction(double arg) {
                return Math.sqrt(arg);
            }
        });
        this.putHiddenProperty("tan", new BuiltinMathFunctionOne("tan", evaluator, functionPrototype){

            public double applyMathFunction(double arg) {
                return Math.tan(arg);
            }
        });
    }

    public String getESClassName() {
        return "Math";
    }

    public static ESObject makeMathObject(Evaluator evaluator, ObjectPrototype prototype, FunctionPrototype functionPrototype) {
        try {
            MathObject mo = new MathObject((ESObject)prototype, evaluator, functionPrototype);
            return mo;
        }
        catch (EcmaScriptException e) {
            e.printStackTrace();
            throw new ProgrammingError(e.getMessage());
        }
    }

    abstract class BuiltinMathFunctionTwo
    extends BuiltinFunctionObject {
        BuiltinMathFunctionTwo(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 2);
        }

        abstract double applyMathFunction(double var1, double var3);

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            double arg2;
            if (arguments.length < 2) {
                throw new EcmaScriptException("Missing parameter in function " + this);
            }
            double arg1 = arguments.length > 0 ? arguments[0].doubleValue() : Double.NaN;
            double d = arg2 = arguments.length > 1 ? arguments[1].doubleValue() : Double.NaN;
            if (Double.isNaN(arg1) || Double.isNaN(arg2)) {
                return new ESNumber(Double.NaN);
            }
            return new ESNumber(this.applyMathFunction(arg1, arg2));
        }
    }

    abstract class BuiltinMathFunctionOne
    extends BuiltinFunctionObject {
        BuiltinMathFunctionOne(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        abstract double applyMathFunction(double var1);

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            double arg;
            double d = arg = arguments.length > 0 ? arguments[0].doubleValue() : Double.NaN;
            if (Double.isNaN(arg)) {
                return new ESNumber(Double.NaN);
            }
            return new ESNumber(this.applyMathFunction(arg));
        }
    }

    abstract class BuiltinMathFunctionZero
    extends BuiltinFunctionObject {
        BuiltinMathFunctionZero(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        abstract double applyMathFunction();

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            return new ESNumber(this.applyMathFunction());
        }
    }
}

