/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ArrayObject;
import FESI.Data.BooleanObject;
import FESI.Data.BuiltinFunctionObject;
import FESI.Data.DateObject;
import FESI.Data.ESBoolean;
import FESI.Data.ESLoader;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.ESWrapper;
import FESI.Data.FunctionObject;
import FESI.Data.FunctionPrototype;
import FESI.Data.MathObject;
import FESI.Data.NumberObject;
import FESI.Data.ObjectObject;
import FESI.Data.ObjectPrototype;
import FESI.Data.StringObject;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.EcmaScriptParseException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;

public class GlobalObject
extends ObjectPrototype {
    private static final String VALUEstring = "value".intern();
    private static final int VALUEhash = VALUEstring.hashCode();
    private static final String ERRORstring = "error".intern();
    private static final int ERRORhash = ERRORstring.hashCode();

    private GlobalObject(ESObject prototype, Evaluator evaluator) {
        super(prototype, evaluator);
    }

    public static GlobalObject makeGlobalObject(Evaluator evaluator) {
        GlobalObject go = null;
        try {
            ObjectPrototype objectPrototype = new ObjectPrototype(null, evaluator);
            FunctionPrototype functionPrototype = new FunctionPrototype(objectPrototype, evaluator, "[Function Prototype]", 0);
            ObjectObject objectObject = new ObjectObject(functionPrototype, evaluator);
            FunctionObject functionObject = new FunctionObject(functionPrototype, evaluator);
            StringObject stringObject = StringObject.makeStringObject(evaluator, objectPrototype, functionPrototype);
            NumberObject numberObject = NumberObject.makeNumberObject(evaluator, objectPrototype, functionPrototype);
            BooleanObject booleanObject = BooleanObject.makeBooleanObject(evaluator, objectPrototype, functionPrototype);
            ArrayObject arrayObject = ArrayObject.makeArrayObject(evaluator, objectPrototype, functionPrototype);
            DateObject dateObject = DateObject.makeDateObject(evaluator, objectPrototype, functionPrototype);
            go = new GlobalObject(objectPrototype, evaluator);
            objectObject.putHiddenProperty("prototype", objectPrototype);
            objectPrototype.putHiddenProperty("constructor", objectObject);
            class ObjectPrototypeToString
            extends BuiltinFunctionObject {
                ObjectPrototypeToString(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    String result = "[object " + thisObject.getESClassName() + "]";
                    return new ESString(result);
                }
            }
            objectPrototype.putHiddenProperty("toString", new ObjectPrototypeToString("toString", evaluator, functionPrototype));
            class ObjectPrototypeValueOf
            extends BuiltinFunctionObject {
                ObjectPrototypeValueOf(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    return thisObject;
                }
            }
            objectPrototype.putHiddenProperty("valueOf", new ObjectPrototypeValueOf("valueOf", evaluator, functionPrototype));
            functionPrototype.putHiddenProperty("constructor", functionObject);
            class FunctionPrototypeToString
            extends BuiltinFunctionObject {
                FunctionPrototypeToString(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    String s = "function " + ((FunctionPrototype)thisObject).getFunctionName() + ((FunctionPrototype)thisObject).getFunctionParametersString() + ((FunctionPrototype)thisObject).getFunctionImplementationString();
                    return new ESString(s);
                }
            }
            functionPrototype.putHiddenProperty("toString", new FunctionPrototypeToString("toString", evaluator, functionPrototype));
            functionObject.putHiddenProperty("prototype", functionPrototype);
            functionObject.putHiddenProperty("length", new ESNumber(1.0));
            evaluator.setObjectPrototype(objectPrototype);
            evaluator.setFunctionPrototype(functionPrototype);
            evaluator.setFunctionObject(functionObject);
            class GlobalObjectThrowError
            extends BuiltinFunctionObject {
                GlobalObjectThrowError(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    ObjectPrototype result = ObjectObject.createObject(this.evaluator);
                    if (arguments.length < 1) {
                        throw new EcmaScriptException("Exception thrown by throwError");
                    }
                    if (arguments[0] instanceof ESWrapper) {
                        Object o = ((ESWrapper)arguments[0]).getJavaObject();
                        if (o instanceof Throwable) {
                            throw new EcmaScriptException(o.toString(), (Throwable)o);
                        }
                        throw new EcmaScriptException(o.toString());
                    }
                    String text = arguments[0].toString();
                    throw new EcmaScriptException(text);
                }
            }
            go.putHiddenProperty("throwError", new GlobalObjectThrowError("throwError", evaluator, functionPrototype));
            class GlobalObjectTryEval
            extends BuiltinFunctionObject {
                GlobalObjectTryEval(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    ObjectPrototype result = ObjectObject.createObject(this.evaluator);
                    if (arguments.length < 1) {
                        result.putProperty(ERRORstring, ESNull.theNull, ERRORhash);
                        return result;
                    }
                    if (!(arguments[0] instanceof ESString)) {
                        result.putProperty(VALUEstring, arguments[0], VALUEhash);
                        result.putProperty(ERRORstring, ESNull.theNull, ERRORhash);
                        return result;
                    }
                    String program = arguments[0].toString();
                    ESValue value = ESUndefined.theUndefined;
                    try {
                        value = this.evaluator.evaluateEvalString(program);
                    }
                    catch (EcmaScriptParseException e) {
                        e.setNeverIncomplete();
                        if (arguments.length > 1) {
                            result.putProperty(VALUEstring, arguments[1], VALUEhash);
                        }
                        result.putProperty(ERRORstring, ESLoader.normalizeValue(e, this.evaluator), ERRORhash);
                        return result;
                    }
                    catch (EcmaScriptException e) {
                        if (arguments.length > 1) {
                            result.putProperty(VALUEstring, arguments[1], VALUEhash);
                        }
                        result.putProperty(ERRORstring, ESLoader.normalizeValue(e, this.evaluator), ERRORhash);
                        return result;
                    }
                    result.putProperty(VALUEstring, value, VALUEhash);
                    result.putProperty(ERRORstring, ESNull.theNull, ERRORhash);
                    return result;
                }
            }
            go.putHiddenProperty("tryEval", new GlobalObjectTryEval("tryEval", evaluator, functionPrototype));
            class GlobalObjectEval
            extends BuiltinFunctionObject {
                GlobalObjectEval(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    if (arguments.length < 1) {
                        return ESUndefined.theUndefined;
                    }
                    if (!(arguments[0] instanceof ESString)) {
                        return arguments[0];
                    }
                    String program = arguments[0].toString();
                    ESValue value = ESUndefined.theUndefined;
                    try {
                        value = this.evaluator.evaluateEvalString(program);
                    }
                    catch (EcmaScriptParseException e) {
                        e.setNeverIncomplete();
                        throw e;
                    }
                    return value;
                }
            }
            go.putHiddenProperty("eval", new GlobalObjectEval("eval", evaluator, functionPrototype));
            class GlobalObjectParseInt
            extends BuiltinFunctionObject {
                GlobalObjectParseInt(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 2);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    if (arguments.length < 1) {
                        return ESUndefined.theUndefined;
                    }
                    int radix = 10;
                    String s = arguments[0].toString().trim();
                    if (arguments.length > 1) {
                        radix = arguments[1].toInt32();
                        if (radix < 2 || radix > 36) {
                            return new ESNumber(Double.NaN);
                        }
                        if (radix == 16 && (s.startsWith("0x") || s.startsWith("0X"))) {
                            s = s.substring(2);
                        }
                    } else if (s.startsWith("0x") || s.startsWith("0X")) {
                        s = s.substring(2);
                        radix = 16;
                    } else if (s.startsWith("0")) {
                        radix = 8;
                    }
                    double d = Double.NaN;
                    int k = -1;
                    block8: for (int i = 0; i < s.length() && k == -1; ++i) {
                        char c = s.charAt(i);
                        switch (radix) {
                            case 2: {
                                if (c >= '0' && '1' >= c) continue block8;
                                k = i;
                                continue block8;
                            }
                            case 8: {
                                if (c >= '0' && '7' >= c) continue block8;
                                k = i;
                                continue block8;
                            }
                            case 10: {
                                if (c >= '0' && '9' >= c) continue block8;
                                k = i;
                                continue block8;
                            }
                            case 16: {
                                if (c >= '0' && '9' >= c || c >= 'a' && 'f' >= c || c >= 'A' && 'F' >= c) continue block8;
                                k = i;
                                continue block8;
                            }
                            default: {
                                throw new EcmaScriptException("Only radix 2,8,10 and 16 supported");
                            }
                        }
                    }
                    if (k > 0) {
                        s = s.substring(0, k);
                    }
                    if (s.length() > 0) {
                        try {
                            d = Long.parseLong(s, radix);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    return new ESNumber(d);
                }
            }
            go.putHiddenProperty("parseInt", new GlobalObjectParseInt("parseInt", evaluator, functionPrototype));
            class GlobalObjectParseFloat
            extends BuiltinFunctionObject {
                GlobalObjectParseFloat(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    int i;
                    if (arguments.length < 1) {
                        return ESUndefined.theUndefined;
                    }
                    String s = arguments[0].toString().trim();
                    Double d = new Double(Double.NaN);
                    boolean efound = false;
                    boolean dotfound = false;
                    for (i = 0; i < s.length(); ++i) {
                        char c = s.charAt(i);
                        if ('0' <= c && c <= '9' || c == '+' || c == '-') continue;
                        if (c == 'e' || c == 'E') {
                            if (efound) break;
                            efound = true;
                            continue;
                        }
                        if (c != '.' || dotfound || efound) break;
                        dotfound = true;
                    }
                    s = s.substring(0, i);
                    try {
                        d = Double.valueOf(s);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    return new ESNumber(d);
                }
            }
            go.putHiddenProperty("parseFloat", new GlobalObjectParseFloat("parseFloat", evaluator, functionPrototype));
            class GlobalObjectEscape
            extends BuiltinFunctionObject {
                GlobalObjectEscape(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    if (arguments.length <= 0) {
                        return ESUndefined.theUndefined;
                    }
                    StringBuffer dst = new StringBuffer();
                    String src = arguments[0].toString();
                    for (int i = 0; i < src.length(); ++i) {
                        char c = src.charAt(i);
                        if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '@' || c == '*' || c == '_' || c == '+' || c == '-' || c == '.' || c == '/') {
                            dst.append(c);
                            continue;
                        }
                        if (c <= '\u000f') {
                            dst.append("%0" + Integer.toHexString(c));
                            continue;
                        }
                        if (c <= '\u00ff') {
                            dst.append("%" + Integer.toHexString(c));
                            continue;
                        }
                        if (c <= '\u0fff') {
                            dst.append("%u0" + Integer.toHexString(c));
                            continue;
                        }
                        dst.append("%u" + Integer.toHexString(c));
                    }
                    return new ESString(dst.toString());
                }
            }
            go.putHiddenProperty("escape", new GlobalObjectEscape("escape", evaluator, functionPrototype));
            class GlobalObjectUnescape
            extends BuiltinFunctionObject {
                GlobalObjectUnescape(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    if (arguments.length <= 0) {
                        return ESUndefined.theUndefined;
                    }
                    StringBuffer dst = new StringBuffer();
                    String src = arguments[0].toString();
                    for (int i = 0; i < src.length(); ++i) {
                        char c = src.charAt(i);
                        if (c == '%') {
                            StringBuffer d = new StringBuffer();
                            if ((c = src.charAt(++i)) == 'u' || c == 'U') {
                                d.append(src.charAt(++i));
                                d.append(src.charAt(++i));
                                d.append(src.charAt(++i));
                                d.append(src.charAt(++i));
                            } else {
                                d.append(src.charAt(i));
                                d.append(src.charAt(++i));
                            }
                            c = (char)Integer.parseInt(d.toString(), 16);
                        }
                        dst.append(c);
                    }
                    return new ESString(dst.toString());
                }
            }
            go.putHiddenProperty("unescape", new GlobalObjectUnescape("unescape", evaluator, functionPrototype));
            class GlobalObjectIsNaN
            extends BuiltinFunctionObject {
                GlobalObjectIsNaN(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    if (arguments.length < 1) {
                        return ESUndefined.theUndefined;
                    }
                    double d = arguments[0].doubleValue();
                    return ESBoolean.makeBoolean(Double.isNaN(d));
                }
            }
            go.putHiddenProperty("isNaN", new GlobalObjectIsNaN("isNaN", evaluator, functionPrototype));
            class GlobalObjectIsFinite
            extends BuiltinFunctionObject {
                GlobalObjectIsFinite(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    if (arguments.length < 1) {
                        return ESUndefined.theUndefined;
                    }
                    double d = arguments[0].doubleValue();
                    return ESBoolean.makeBoolean(!Double.isInfinite(d));
                }
            }
            go.putHiddenProperty("isFinite", new GlobalObjectIsFinite("isFinite", evaluator, functionPrototype));
            go.putHiddenProperty("Object", objectObject);
            go.putHiddenProperty("Function", functionObject);
            go.putHiddenProperty("String", stringObject);
            go.putHiddenProperty("Number", numberObject);
            go.putHiddenProperty("Boolean", booleanObject);
            go.putHiddenProperty("Array", arrayObject);
            go.putHiddenProperty("Date", dateObject);
            go.putHiddenProperty("NaN", new ESNumber(Double.NaN));
            go.putHiddenProperty("Infinity", new ESNumber(Double.POSITIVE_INFINITY));
            go.putHiddenProperty("undefined", ESUndefined.theUndefined);
            go.putHiddenProperty("Array", ArrayObject.makeArrayObject(evaluator, objectPrototype, functionPrototype));
            go.putHiddenProperty("Math", MathObject.makeMathObject(evaluator, objectPrototype, functionPrototype));
        }
        catch (EcmaScriptException e) {
            e.printStackTrace();
            throw new ProgrammingError(e.getMessage());
        }
        return go;
    }
}

