/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESBoolean;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ValueDescription;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;
import java.util.Enumeration;

public abstract class ESValue {
    public static final int EStypeUndefined = 1;
    public static final int EStypeNull = 2;
    public static final int EStypeBoolean = 3;
    public static final int EStypeNumber = 4;
    public static final int EStypeString = 5;
    public static final int EStypeObject = 6;

    public abstract String toDetailString();

    public abstract Object toJavaObject();

    public double doubleValue() throws EcmaScriptException {
        throw new EcmaScriptException("Conversion to double unsupported by " + this);
    }

    public boolean booleanValue() throws EcmaScriptException {
        throw new EcmaScriptException("Conversion to boolean unsupported by " + this);
    }

    public ESValue toESObject(Evaluator evaluator) throws EcmaScriptException {
        throw new EcmaScriptException("Conversion to object unsupported by " + this);
    }

    public double toInteger() throws EcmaScriptException {
        double value = this.doubleValue();
        if (Double.isNaN(value)) {
            return 0.0;
        }
        if (value == 0.0 || Double.isInfinite(value)) {
            return value;
        }
        return (long)value;
    }

    public int toInt32() throws EcmaScriptException {
        double value = this.toInteger();
        return (int)value;
    }

    public int toUInt32() throws EcmaScriptException {
        double value = this.toInteger();
        return (int)value;
    }

    public short toUInt16() throws EcmaScriptException {
        double value = this.toInteger();
        return (short)value;
    }

    public ESValue toESBoolean() throws EcmaScriptException {
        return ESBoolean.makeBoolean(this.booleanValue());
    }

    public ESValue toESString() {
        return new ESString(this.toString());
    }

    public ESValue toESNumber() throws EcmaScriptException {
        double d = this.doubleValue();
        return new ESNumber(d);
    }

    public abstract boolean isPrimitive();

    public abstract ESValue toESPrimitive() throws EcmaScriptException;

    public abstract ESValue toESPrimitive(int var1) throws EcmaScriptException;

    public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        throw new EcmaScriptException("Function called on non object: " + this);
    }

    public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        throw new EcmaScriptException("'new' called on non object: " + this);
    }

    public boolean isNumberValue() {
        return false;
    }

    public boolean isStringValue() {
        return false;
    }

    public boolean isBooleanValue() {
        return false;
    }

    public abstract int getTypeOf();

    public abstract String getTypeofString();

    public abstract boolean isComposite();

    public Enumeration getAllDescriptions() {
        return null;
    }

    public abstract ValueDescription getDescription(String var1);

    public ValueDescription getDescription() {
        return this.getDescription(null);
    }
}

