/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;

public class ESReference {
    private ESObject base;
    private String propertyName;
    private int hash;

    public ESReference(ESValue base, String propertyName, int hash) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName");
        }
        this.base = (ESObject)base;
        this.propertyName = propertyName;
        this.hash = hash;
    }

    public ESValue getBase() throws EcmaScriptException {
        return this.base;
    }

    public String getPropertyName() throws EcmaScriptException {
        return this.propertyName;
    }

    public ESValue getValue() throws EcmaScriptException {
        if (this.base == null) {
            throw new EcmaScriptException("global variable '" + this.propertyName + "' does not have a value");
        }
        return this.base.getProperty(this.propertyName, this.hash);
    }

    public void putValue(ESObject g, ESValue v) throws EcmaScriptException {
        if (this.base == null) {
            g.putProperty(this.propertyName, v, this.hash);
        } else {
            this.base.putProperty(this.propertyName, v, this.hash);
        }
    }

    public String toDetailString() {
        return "ES:*<" + (this.base == null ? "null" : this.base.toString()) + ":" + this.propertyName + ">";
    }

    public String toString() {
        return (this.base == null ? "" : "{" + this.base.toString() + "}.") + this.propertyName;
    }
}

