/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESLoader;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Data.ESWrapper;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.LocalClassLoader;

public class ESPackages
extends ESLoader {
    public ESPackages(Evaluator evaluator) {
        super(evaluator);
    }

    public ESPackages(String packageName, ESPackages previousPackage, LocalClassLoader classLoader, Evaluator evaluator) {
        super(packageName, previousPackage, classLoader, evaluator);
    }

    public ESObject getPrototype() {
        throw new ProgrammingError("Cannot get prototype of Package");
    }

    public String getESClassName() {
        return "Packages";
    }

    private Class loadClass(String className) throws ClassNotFoundException {
        if (this.classLoader == null) {
            return Class.forName(className);
        }
        return this.classLoader.loadClass(className);
    }

    public ESValue getProperty(String propertyName, int hash) throws EcmaScriptException {
        ESValue value = this.properties.get(propertyName, hash);
        if (value == null) {
            String packageName = this.buildPrefix();
            String fullName = packageName == null ? propertyName : packageName + "." + propertyName;
            try {
                Class cls = this.loadClass(fullName);
                if (debugJavaAccess) {
                    System.out.println("** Class '" + fullName + "' loaded");
                }
                value = new ESWrapper(cls, this.evaluator);
            }
            catch (ClassNotFoundException e) {
                if (debugJavaAccess) {
                    System.out.println("** Could not load '" + fullName + "' by " + this);
                    System.out.println("** Exception: " + e);
                }
                value = new ESPackages(propertyName, this, this.classLoader, this.evaluator);
            }
            this.properties.put(propertyName, hash, false, false, value);
        }
        return value;
    }

    public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        if (this.previousPackage == null && this.classLoader == null) {
            if (arguments.length < 1) {
                throw new EcmaScriptException("Missing class directory or file name");
            }
            String directoryOrJar = arguments[0].toString();
            LocalClassLoader classLoader = LocalClassLoader.makeLocalClassLoader(directoryOrJar);
            return new ESPackages(null, null, classLoader, this.evaluator);
        }
        throw new EcmaScriptException("Java class not found: '" + this.buildPrefix() + "'");
    }

    public String getTypeofString() {
        return "JavaPackage";
    }

    public String toDetailString() {
        return "ES:<" + this.getESClassName() + ":'" + this.buildPrefix() + "'" + (this.classLoader == null ? "" : ",@" + this.classLoader) + ">";
    }
}

