/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.JSWrapper;
import FESI.Data.ValueDescription;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.FesiHashtable;
import FESI.Interpreter.ScopeChain;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public abstract class ESObject
extends ESValue {
    protected FesiHashtable properties;
    protected Evaluator evaluator;
    private ESObject prototype = null;
    private static final String TOSTRINGstring = "toString".intern();
    private static final int TOSTRINGhash = TOSTRINGstring.hashCode();
    private static final String VALUEOFstring = "valueOf".intern();
    private static final int VALUEOFhash = VALUEOFstring.hashCode();

    protected ESObject(ESObject prototype, Evaluator evaluator) {
        this.prototype = prototype;
        this.properties = new FesiHashtable();
        this.evaluator = evaluator;
    }

    protected ESObject(ESObject prototype, Evaluator evaluator, int initialSize) {
        this.prototype = prototype;
        this.properties = new FesiHashtable(initialSize);
        this.evaluator = evaluator;
    }

    public final Evaluator getEvaluator() {
        return this.evaluator;
    }

    public final boolean isPrimitive() {
        return false;
    }

    public ESObject getPrototype() {
        return this.prototype;
    }

    public String getESClassName() {
        return "Object";
    }

    public int getTypeOf() {
        return 6;
    }

    public ESValue getPropertyInScope(String propertyName, ScopeChain previousScope, int hash) throws EcmaScriptException {
        boolean hasTheProperty;
        ESValue value = this.getProperty(propertyName, hash);
        if (value == ESUndefined.theUndefined && !(hasTheProperty = this.properties.containsKey(propertyName, hash))) {
            if (previousScope == null) {
                throw new EcmaScriptException("global variable '" + propertyName + "' does not have a value");
            }
            value = previousScope.getValue(propertyName, hash);
        }
        return value;
    }

    public ESValue getProperty(String propertyName, int hash) throws EcmaScriptException {
        ESValue value = this.properties.get(propertyName, hash);
        if (value == null) {
            value = this.prototype == null ? ESUndefined.theUndefined : this.prototype.getProperty(propertyName, hash);
        }
        return value;
    }

    public ESValue getProperty(int index) throws EcmaScriptException {
        String iString = Integer.toString(index);
        return this.getProperty(iString, iString.hashCode());
    }

    public boolean hasProperty(String propertyName, int hash) throws EcmaScriptException {
        boolean found = this.properties.containsKey(propertyName, hash);
        if (!found && this.prototype != null) {
            found = this.prototype.hasProperty(propertyName, hash);
        }
        return found;
    }

    public boolean isHiddenProperty(String propertyName, int hash) {
        return this.properties.isHidden(propertyName, hash);
    }

    public boolean isDirectEnumerator() {
        return false;
    }

    public Enumeration getProperties() {
        return new Enumeration(){
            Enumeration props;
            String currentKey;
            int currentHash;
            boolean inside;
            {
                this.props = ESObject.this.properties.keys();
                this.currentKey = null;
                this.currentHash = 0;
                this.inside = false;
            }

            public boolean hasMoreElements() {
                if (this.currentKey != null) {
                    return true;
                }
                while (this.props.hasMoreElements()) {
                    this.currentKey = (String)this.props.nextElement();
                    this.currentHash = this.currentKey.hashCode();
                    if (this.inside ? ESObject.this.properties.containsKey(this.currentKey, this.currentHash) : ESObject.this.isHiddenProperty(this.currentKey, this.currentHash)) continue;
                    return true;
                }
                if (!this.inside && ESObject.this.prototype != null) {
                    this.inside = true;
                    this.props = ESObject.this.prototype.getProperties();
                    while (this.props.hasMoreElements()) {
                        this.currentKey = (String)this.props.nextElement();
                        this.currentHash = this.currentKey.hashCode();
                        if (ESObject.this.properties.containsKey(this.currentKey, this.currentHash)) continue;
                        return true;
                    }
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    String key = this.currentKey;
                    this.currentKey = null;
                    return key;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Enumeration getAllProperties() {
        return new Enumeration(){
            String[] specialProperties;
            int specialEnumerator;
            Enumeration props;
            String currentKey;
            int currentHash;
            boolean inside;
            {
                this.specialProperties = ESObject.this.getSpecialPropertyNames();
                this.specialEnumerator = 0;
                this.props = ESObject.this.properties.keys();
                this.currentKey = null;
                this.currentHash = 0;
                this.inside = false;
            }

            public boolean hasMoreElements() {
                if (this.currentKey != null) {
                    return true;
                }
                if (this.specialEnumerator < this.specialProperties.length) {
                    this.currentKey = this.specialProperties[this.specialEnumerator];
                    this.currentHash = this.currentKey.hashCode();
                    ++this.specialEnumerator;
                    return true;
                }
                while (this.props.hasMoreElements()) {
                    this.currentKey = (String)this.props.nextElement();
                    this.currentHash = this.currentKey.hashCode();
                    if (this.inside && ESObject.this.properties.containsKey(this.currentKey, this.currentHash)) continue;
                    return true;
                }
                if (!this.inside && ESObject.this.prototype != null) {
                    this.inside = true;
                    this.props = ESObject.this.prototype.getProperties();
                    while (this.props.hasMoreElements()) {
                        this.currentKey = (String)this.props.nextElement();
                        this.currentHash = this.currentKey.hashCode();
                        if (ESObject.this.properties.containsKey(this.currentKey, this.currentHash)) continue;
                        return true;
                    }
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    String key = this.currentKey;
                    this.currentKey = null;
                    return key;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public void putProperty(String propertyName, ESValue propertyValue, int hash) throws EcmaScriptException {
        this.properties.put(propertyName, hash, false, false, propertyValue);
    }

    public void putProperty(int index, ESValue propertyValue) throws EcmaScriptException {
        String iString = Integer.toString(index);
        this.putProperty(iString, propertyValue, iString.hashCode());
    }

    public void putHiddenProperty(String propertyName, ESValue propertyValue) throws EcmaScriptException {
        propertyName = propertyName.intern();
        int hash = propertyName.hashCode();
        this.properties.put(propertyName, hash, true, false, propertyValue);
    }

    public boolean deleteProperty(String propertyName, int hash) throws EcmaScriptException {
        this.properties.remove(propertyName, hash);
        return true;
    }

    public ESValue getDefaultValue(int hint) throws EcmaScriptException {
        ESValue theResult = null;
        ESValue theFunction = null;
        if (hint == 5) {
            theFunction = this.getProperty(TOSTRINGstring, TOSTRINGhash);
            if (theFunction instanceof ESObject && (theResult = theFunction.callFunction(this, new ESValue[0])).isPrimitive()) {
                return theResult;
            }
            theFunction = this.getProperty(VALUEOFstring, VALUEOFhash);
            if (theFunction instanceof ESObject && (theResult = theFunction.callFunction(this, new ESValue[0])).isPrimitive()) {
                return theResult;
            }
            throw new EcmaScriptException("No default value for " + super.toString() + " and hint " + hint);
        }
        if (hint == 4) {
            theFunction = this.getProperty(VALUEOFstring, VALUEOFhash);
            if (theFunction instanceof ESObject && (theResult = theFunction.callFunction(this, new ESValue[0])).isPrimitive()) {
                return theResult;
            }
            theFunction = this.getProperty(TOSTRINGstring, TOSTRINGhash);
            if (theFunction instanceof ESObject && (theResult = theFunction.callFunction(this, new ESValue[0])).isPrimitive()) {
                return theResult;
            }
        }
        throw new EcmaScriptException("No default value for " + this + " and hint " + hint);
    }

    public ESValue getDefaultValue() throws EcmaScriptException {
        return this.getDefaultValue(4);
    }

    public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        throw new EcmaScriptException("No function defined on: " + this);
    }

    public ESValue doIndirectCall(Evaluator evaluator, ESObject target, String functionName, ESValue[] arguments) throws EcmaScriptException, NoSuchMethodException {
        ESValue theFunction = this.properties.get(functionName, functionName.hashCode());
        if (theFunction == null) {
            if (this.prototype == null) {
                throw new EcmaScriptException("The function '" + functionName + "' is not defined for object '" + target.toString() + "'");
            }
            return this.prototype.doIndirectCall(evaluator, target, functionName, arguments);
        }
        return theFunction.callFunction(target, arguments);
    }

    public ESValue doIndirectCallInScope(Evaluator evaluator, ScopeChain previousScope, ESObject thisObject, String functionName, int hash, ESValue[] arguments) throws EcmaScriptException {
        ESValue theFunction = this.properties.get(functionName, hash);
        if (theFunction == null) {
            if (previousScope == null) {
                throw new EcmaScriptException("no global function named '" + functionName + "'");
            }
            return previousScope.doIndirectCall(evaluator, thisObject, functionName, hash, arguments);
        }
        return theFunction.callFunction(thisObject, arguments);
    }

    public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        throw new EcmaScriptException("No constructor defined on: " + this);
    }

    public double doubleValue() throws EcmaScriptException {
        ESValue value = ESUndefined.theUndefined;
        double d = Double.NaN;
        try {
            value = this.toESPrimitive(4);
            d = value.doubleValue();
        }
        catch (EcmaScriptException e) {
            throw new ProgrammingError(e.getMessage());
        }
        return d;
    }

    public boolean booleanValue() throws EcmaScriptException {
        return true;
    }

    public String toString() {
        ESValue value = ESUndefined.theUndefined;
        String string = null;
        try {
            value = this.toESPrimitive(5);
        }
        catch (EcmaScriptException e) {
            return this.toDetailString();
        }
        string = value.toString();
        return string;
    }

    public final ESValue toESObject(Evaluator evaluator) throws EcmaScriptException {
        return this;
    }

    public final ESValue toESPrimitive(int preferedType) throws EcmaScriptException {
        return this.getDefaultValue(preferedType);
    }

    public final ESValue toESPrimitive() throws EcmaScriptException {
        return this.getDefaultValue();
    }

    public Object toJavaObject() {
        return new JSWrapper(this, this.evaluator);
    }

    public String getTypeofString() {
        return "object";
    }

    public String toDetailString() {
        return "ES:[" + this.getESClassName() + "]";
    }

    public boolean isComposite() {
        return true;
    }

    public String[] getSpecialPropertyNames() {
        return new String[0];
    }

    public Enumeration getAllDescriptions() {
        return new Enumeration(){
            String[] specialProperties;
            int specialEnumerator;
            Enumeration props;
            String currentKey;
            int currentHash;
            boolean inside;
            boolean inSpecial;
            {
                this.specialProperties = ESObject.this.getSpecialPropertyNames();
                this.specialEnumerator = 0;
                this.props = ESObject.this.properties.keys();
                this.currentKey = null;
                this.currentHash = 0;
                this.inside = false;
                this.inSpecial = true;
            }

            public boolean hasMoreElements() {
                if (this.currentKey != null) {
                    return true;
                }
                if (this.specialEnumerator < this.specialProperties.length) {
                    this.currentKey = this.specialProperties[this.specialEnumerator];
                    this.currentHash = this.currentKey.hashCode();
                    ++this.specialEnumerator;
                    return true;
                }
                this.inSpecial = false;
                if (this.props.hasMoreElements()) {
                    this.currentKey = (String)this.props.nextElement();
                    this.currentHash = this.currentKey.hashCode();
                    return true;
                }
                if (!this.inside && ESObject.this.prototype != null) {
                    this.inside = true;
                    this.props = ESObject.this.prototype.getProperties();
                    if (this.props.hasMoreElements()) {
                        this.currentKey = (String)this.props.nextElement();
                        this.currentHash = this.currentKey.hashCode();
                        return true;
                    }
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    String key = this.currentKey;
                    int hash = key.hashCode();
                    this.currentKey = null;
                    ESValue value = null;
                    try {
                        value = ESObject.this.getProperty(key, hash);
                    }
                    catch (EcmaScriptException e) {
                        throw new ProgrammingError("Unexpected exception " + e);
                    }
                    String propertyKind = this.inSpecial ? "HIDDEN" : (this.inside && ESObject.this.properties.containsKey(key, hash) ? "INVISIBLE" : (ESObject.this.isHiddenProperty(key, hash) ? "HIDDEN" : "VISIBLE"));
                    propertyKind = propertyKind + (this.inside ? " PROTOTYPE" : " OBJECT");
                    propertyKind = propertyKind + " PROPERTY";
                    return new ValueDescription(key, propertyKind, value.toString());
                }
                throw new NoSuchElementException();
            }
        };
    }

    public ValueDescription getDescription(String name) {
        return new ValueDescription(name, "OBJECT", this.toString());
    }
}

