/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ArrayPrototype;
import FESI.Data.CompatibilityDescriptor;
import FESI.Data.DatePrototype;
import FESI.Data.ESArrayWrapper;
import FESI.Data.ESBoolean;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Data.ESWrapper;
import FESI.Data.JSWrapper;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.LocalClassLoader;
import FESI.Interpreter.ScopeChain;
import FESI.jslib.JSFunction;
import java.util.Date;

public abstract class ESLoader
extends ESObject {
    protected static boolean debugJavaAccess = false;
    protected static boolean debugLoader = false;
    protected String packageName = null;
    protected ESLoader previousPackage = null;
    protected LocalClassLoader classLoader = null;
    private static CompatibilityDescriptor nonCompatible = new CompatibilityDescriptor(-1, null, null);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Date;

    public static void setDebugJavaAccess(boolean b) {
        debugJavaAccess = b;
    }

    public static boolean isDebugJavaAccess() {
        return debugJavaAccess;
    }

    public static void setDebugLoader(boolean b) {
        debugLoader = b;
    }

    public static boolean isDebugLoader() {
        return debugLoader;
    }

    public ESLoader(Evaluator evaluator) {
        super(null, evaluator);
    }

    public ESLoader(String packageName, ESLoader previousPackage, LocalClassLoader classLoader, Evaluator evaluator) {
        super(null, evaluator);
        this.packageName = packageName;
        this.previousPackage = previousPackage;
        this.classLoader = classLoader;
    }

    protected String buildPrefix() {
        if (this.previousPackage == null) {
            return null;
        }
        String prefix = this.previousPackage.buildPrefix();
        if (prefix == null) {
            return this.packageName;
        }
        return prefix + "." + this.packageName;
    }

    public ESObject getPrototype() {
        throw new ProgrammingError("Cannot get prototype of Package");
    }

    public int getTypeOf() {
        return 6;
    }

    public ESValue getPropertyInScope(String propertyName, ScopeChain previousScope, int hash) throws EcmaScriptException {
        throw new EcmaScriptException("A loader object (" + this + ") should not be part of a with statement");
    }

    public boolean hasProperty(String propertyName, int hash) throws EcmaScriptException {
        return true;
    }

    public boolean isHiddenProperty(String propertyName, int hash) {
        return false;
    }

    public void putProperty(String propertyName, ESValue propertyValue, int hash) throws EcmaScriptException {
    }

    public void putHiddenProperty(String propertyName, ESValue propertyValue) throws EcmaScriptException {
        throw new ProgrammingError("Cannot put hidden property in " + this);
    }

    public boolean deleteProperty(String propertyName, int hash) throws EcmaScriptException {
        return false;
    }

    public ESValue getDefaultValue(int hint) throws EcmaScriptException {
        if (hint == 5) {
            return new ESString(this.toString());
        }
        throw new EcmaScriptException("No default value for " + this + " and hint " + hint);
    }

    public ESValue getDefaultValue() throws EcmaScriptException {
        return this.getDefaultValue(5);
    }

    public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        throw new EcmaScriptException("No contructor for loader object: " + this);
    }

    public double doubleValue() {
        double d = Double.NaN;
        return d;
    }

    public boolean booleanValue() {
        return true;
    }

    public String toString() {
        return this.toDetailString();
    }

    static boolean isBasicClass(Class cls) {
        return cls == (class$java$lang$String == null ? (class$java$lang$String = ESLoader.class$("java.lang.String")) : class$java$lang$String) || cls == (class$java$lang$Character == null ? (class$java$lang$Character = ESLoader.class$("java.lang.Character")) : class$java$lang$Character) || cls == (class$java$lang$Byte == null ? (class$java$lang$Byte = ESLoader.class$("java.lang.Byte")) : class$java$lang$Byte) || cls == (class$java$lang$Short == null ? (class$java$lang$Short = ESLoader.class$("java.lang.Short")) : class$java$lang$Short) || cls == (class$java$lang$Integer == null ? (class$java$lang$Integer = ESLoader.class$("java.lang.Integer")) : class$java$lang$Integer) || cls == (class$java$lang$Long == null ? (class$java$lang$Long = ESLoader.class$("java.lang.Long")) : class$java$lang$Long) || cls == (class$java$lang$Float == null ? (class$java$lang$Float = ESLoader.class$("java.lang.Float")) : class$java$lang$Float) || cls == (class$java$lang$Double == null ? (class$java$lang$Double = ESLoader.class$("java.lang.Double")) : class$java$lang$Double) || cls == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ESLoader.class$("java.lang.Boolean")) : class$java$lang$Boolean) || cls == (class$java$util$Date == null ? (class$java$util$Date = ESLoader.class$("java.util.Date")) : class$java$util$Date);
    }

    static boolean isPrimitiveNumberClass(Class cls) {
        return cls == (class$java$lang$Byte == null ? (class$java$lang$Byte = ESLoader.class$("java.lang.Byte")) : class$java$lang$Byte) || cls == (class$java$lang$Short == null ? (class$java$lang$Short = ESLoader.class$("java.lang.Short")) : class$java$lang$Short) || cls == (class$java$lang$Integer == null ? (class$java$lang$Integer = ESLoader.class$("java.lang.Integer")) : class$java$lang$Integer) || cls == (class$java$lang$Long == null ? (class$java$lang$Long = ESLoader.class$("java.lang.Long")) : class$java$lang$Long) || cls == (class$java$lang$Float == null ? (class$java$lang$Float = ESLoader.class$("java.lang.Float")) : class$java$lang$Float) || cls == (class$java$lang$Double == null ? (class$java$lang$Double = ESLoader.class$("java.lang.Double")) : class$java$lang$Double);
    }

    public static ESValue normalizeValue(Object obj, Evaluator evaluator) throws EcmaScriptException {
        if (obj == null) {
            return ESNull.theNull;
        }
        if (obj instanceof String) {
            return new ESString((String)obj);
        }
        if (ESLoader.isPrimitiveNumberClass(obj.getClass())) {
            return new ESNumber(((Number)obj).doubleValue());
        }
        if (obj instanceof Boolean) {
            return ESBoolean.makeBoolean((Boolean)obj);
        }
        if (obj instanceof Character) {
            return new ESNumber(((Character)obj).charValue());
        }
        if (obj instanceof JSFunction) {
            return JSWrapper.wrapJSFunction(evaluator, (JSFunction)obj);
        }
        if (obj instanceof JSWrapper) {
            return ((JSWrapper)obj).getESObject();
        }
        if (obj instanceof Date) {
            return new DatePrototype(evaluator, (Date)obj);
        }
        if (obj instanceof ESWrapper) {
            return (ESWrapper)obj;
        }
        if (obj instanceof ESArrayWrapper) {
            return (ESArrayWrapper)obj;
        }
        if (obj.getClass().isArray()) {
            return new ESArrayWrapper(obj, evaluator);
        }
        return new ESWrapper(obj, evaluator);
    }

    public static ESObject normalizeObject(Object obj, Evaluator evaluator) throws EcmaScriptException {
        ESValue value = ESLoader.normalizeValue(obj, evaluator);
        return (ESObject)value.toESObject(evaluator);
    }

    private static Class convertPrimitive(Class target) {
        if (target == Boolean.TYPE) {
            target = class$java$lang$Boolean == null ? (class$java$lang$Boolean = ESLoader.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        } else if (target == Character.TYPE) {
            target = class$java$lang$Character == null ? (class$java$lang$Character = ESLoader.class$("java.lang.Character")) : class$java$lang$Character;
        } else if (target == Byte.TYPE) {
            target = class$java$lang$Byte == null ? (class$java$lang$Byte = ESLoader.class$("java.lang.Byte")) : class$java$lang$Byte;
        } else if (target == Short.TYPE) {
            target = class$java$lang$Short == null ? (class$java$lang$Short = ESLoader.class$("java.lang.Short")) : class$java$lang$Short;
        } else if (target == Integer.TYPE) {
            target = class$java$lang$Integer == null ? (class$java$lang$Integer = ESLoader.class$("java.lang.Integer")) : class$java$lang$Integer;
        } else if (target == Long.TYPE) {
            target = class$java$lang$Long == null ? (class$java$lang$Long = ESLoader.class$("java.lang.Long")) : class$java$lang$Long;
        } else if (target == Float.TYPE) {
            target = class$java$lang$Float == null ? (class$java$lang$Float = ESLoader.class$("java.lang.Float")) : class$java$lang$Float;
        } else if (target == Double.TYPE) {
            target = class$java$lang$Double == null ? (class$java$lang$Double = ESLoader.class$("java.lang.Double")) : class$java$lang$Double;
        } else {
            throw new ProgrammingError("Not a recognized primitive type: " + target);
        }
        return target;
    }

    private static int getNumberSize(Class cls) {
        if (cls == (class$java$lang$Byte == null ? (class$java$lang$Byte = ESLoader.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return 1;
        }
        if (cls == (class$java$lang$Character == null ? (class$java$lang$Character = ESLoader.class$("java.lang.Character")) : class$java$lang$Character)) {
            return 2;
        }
        if (cls == (class$java$lang$Short == null ? (class$java$lang$Short = ESLoader.class$("java.lang.Short")) : class$java$lang$Short)) {
            return 2;
        }
        if (cls == (class$java$lang$Integer == null ? (class$java$lang$Integer = ESLoader.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return 3;
        }
        if (cls == (class$java$lang$Long == null ? (class$java$lang$Long = ESLoader.class$("java.lang.Long")) : class$java$lang$Long)) {
            return 4;
        }
        if (cls == (class$java$lang$Float == null ? (class$java$lang$Float = ESLoader.class$("java.lang.Float")) : class$java$lang$Float)) {
            return 5;
        }
        if (cls == (class$java$lang$Double == null ? (class$java$lang$Double = ESLoader.class$("java.lang.Double")) : class$java$lang$Double)) {
            return 6;
        }
        throw new ProgrammingError("Unexpected number class");
    }

    static CompatibilityDescriptor areParametersCompatible(Class[] target, Object[] params) {
        int n = target.length;
        if (n != params.length) {
            return nonCompatible;
        }
        boolean[] convertToChar = null;
        Object[] convertedArrays = null;
        int distance = 0;
        for (int i = 0; i < n; ++i) {
            boolean accepted = false;
            Class targetClass = target[i];
            Class<?> sourceClass = null;
            String debugInfo = " not accepted";
            if (params[i] == null) {
                if (targetClass.isPrimitive()) {
                    accepted = false;
                    debugInfo = " rejected (null cannot be assigned to primitive)";
                } else {
                    accepted = true;
                    debugInfo = " accepted (null to Object)";
                }
            } else {
                if (targetClass.isPrimitive()) {
                    targetClass = ESLoader.convertPrimitive(targetClass);
                }
                sourceClass = params[i].getClass();
                accepted = targetClass.isAssignableFrom(sourceClass);
                debugInfo = " accepted (subclassing)";
                if (!accepted) {
                    if ((ESLoader.isPrimitiveNumberClass(sourceClass) || sourceClass == (class$java$lang$Character == null ? ESLoader.class$("java.lang.Character") : class$java$lang$Character)) && ESLoader.isPrimitiveNumberClass(targetClass)) {
                        int sourceSize;
                        int targetSize = ESLoader.getNumberSize(targetClass);
                        if (targetSize > (sourceSize = ESLoader.getNumberSize(sourceClass))) {
                            accepted = true;
                            debugInfo = " accepted (number widening: " + (distance += Math.abs(targetSize - sourceSize)) + ")";
                        } else {
                            debugInfo = " rejected (not widening numbers)";
                        }
                    } else if ((targetClass == (class$java$lang$Character == null ? ESLoader.class$("java.lang.Character") : class$java$lang$Character) || targetClass == (class$java$lang$Integer == null ? ESLoader.class$("java.lang.Integer") : class$java$lang$Integer) || targetClass == (class$java$lang$Long == null ? ESLoader.class$("java.lang.Long") : class$java$lang$Long) || targetClass == (class$java$lang$Float == null ? ESLoader.class$("java.lang.Float") : class$java$lang$Float) || targetClass == (class$java$lang$Double == null ? ESLoader.class$("java.lang.Double") : class$java$lang$Double)) && params[i] instanceof String) {
                        if (((String)params[i]).length() == 1) {
                            accepted = true;
                            if (convertToChar == null) {
                                convertToChar = new boolean[n];
                            }
                            convertToChar[i] = true;
                            debugInfo = " accepted (String(1) as Character)";
                        } else {
                            debugInfo = " rejected (String not of length 1)";
                        }
                    } else if (targetClass.isArray()) {
                        if (params[i] instanceof JSWrapper) {
                            ESObject esArray = ((JSWrapper)params[i]).getESObject();
                            if (esArray instanceof ArrayPrototype) {
                                Object array = null;
                                try {
                                    array = ((ArrayPrototype)esArray).toJavaArray(targetClass.getComponentType());
                                    accepted = true;
                                    debugInfo = " accepted (array converted)";
                                    if (convertedArrays == null) {
                                        convertedArrays = new Object[n];
                                    }
                                    convertedArrays[i] = array;
                                }
                                catch (EcmaScriptException e) {
                                    debugInfo = " rejected (" + e.getMessage() + ")";
                                }
                            } else {
                                debugInfo = " rejected (EcmaScript object is not an array)";
                            }
                        } else {
                            debugInfo = " rejected (only same native array or EcmaScript Array can be assigned to array)";
                        }
                    } else {
                        debugInfo = " rejected (incompatible types)";
                    }
                }
            }
            if (debugJavaAccess) {
                System.out.println(" Assign " + sourceClass + " to " + target[i] + debugInfo);
            }
            if (accepted) continue;
            return nonCompatible;
        }
        return new CompatibilityDescriptor(distance, convertToChar, convertedArrays);
    }

    public static String typeName(Class t) {
        String brackets = "";
        while (t.isArray()) {
            brackets = brackets + "[]";
            t = t.getComponentType();
        }
        return t.getName() + brackets;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

