/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESLoader;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Data.ESWrapper;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.LocalClassLoader;
import java.beans.Beans;
import java.io.IOException;

public class ESBeans
extends ESLoader {
    public ESBeans(Evaluator evaluator) {
        super(evaluator);
    }

    public ESBeans(String packageName, ESBeans previousPackage, LocalClassLoader classLoader, Evaluator evaluator) {
        super(packageName, previousPackage, classLoader, evaluator);
    }

    public ESObject getPrototype() {
        throw new ProgrammingError("Cannot get prototype of Beans");
    }

    public String getESClassName() {
        return "Beans";
    }

    public ESValue getProperty(String propertyName, int hash) throws EcmaScriptException {
        ESValue value = this.properties.get(propertyName, hash);
        if (value == null) {
            String packageName = this.buildPrefix();
            value = new ESBeans(propertyName, this, this.classLoader, this.evaluator);
            this.properties.put(propertyName, hash, false, false, value);
        }
        return value;
    }

    public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        if (this.previousPackage == null && this.classLoader == null) {
            if (arguments.length < 1) {
                throw new EcmaScriptException("Missing class directory or jar file name");
            }
            String directoryOrJar = arguments[0].toString();
            LocalClassLoader classLoader = LocalClassLoader.makeLocalClassLoader(directoryOrJar);
            return new ESBeans(null, null, classLoader, this.evaluator);
        }
        throw new EcmaScriptException("Java class not found: '" + this.buildPrefix() + "'");
    }

    public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        String beanName = this.buildPrefix();
        ESWrapper value = null;
        if (beanName == null) {
            throw new EcmaScriptException("cannot create beans without a package name");
        }
        try {
            Object bean = Beans.instantiate(this.classLoader, beanName);
            if (debugJavaAccess) {
                System.out.println(" ** Bean '" + beanName + "' created");
            }
            value = new ESWrapper(bean, this.evaluator, true);
        }
        catch (ClassNotFoundException e) {
            throw new EcmaScriptException("Bean '" + beanName + "' not found: " + e);
        }
        catch (IOException e) {
            throw new EcmaScriptException("IOexception loading bean '" + beanName + "': " + e);
        }
        return value;
    }

    public String getTypeofString() {
        return "JavaBeans";
    }

    public String toDetailString() {
        return "ES:<" + this.getESClassName() + ":'" + this.buildPrefix() + "'" + (this.classLoader == null ? "" : ",@" + this.classLoader) + ">";
    }
}

