/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.ScopeChain;

public final class ESArguments
extends ESObject {
    private ESObject callee;
    private int length;
    String[] argumentNames;

    private ESArguments(ESObject prototype, Evaluator evaluator, String[] argumentNames, int length, ESObject callee) {
        super(prototype, evaluator, length < 3 ? 5 : 11);
        this.argumentNames = argumentNames;
        this.length = length;
        this.callee = callee;
    }

    public ESValue getPropertyInScope(String propertyName, ScopeChain previousScope, int hash) throws EcmaScriptException {
        if (propertyName.equals("callee")) {
            return this.callee;
        }
        if (propertyName.equals("arguments")) {
            return this;
        }
        if (propertyName.equals("length")) {
            return new ESNumber(this.length);
        }
        if (super.hasProperty(propertyName, hash)) {
            return super.getProperty(propertyName, hash);
        }
        int index = -1;
        try {
            char c = propertyName.charAt(0);
            if ('0' <= c && c <= '9') {
                index = Integer.parseInt(propertyName);
            }
        }
        catch (NumberFormatException e) {
        }
        catch (StringIndexOutOfBoundsException e) {
            // empty catch block
        }
        if (index >= 0 && index < this.argumentNames.length) {
            propertyName = this.argumentNames[index];
            hash = propertyName.hashCode();
            return super.getProperty(propertyName, hash);
        }
        if (previousScope == null) {
            throw new EcmaScriptException("global variable '" + propertyName + "' does not have a value");
        }
        return previousScope.getValue(propertyName, hash);
    }

    public ESValue doIndirectCallInScope(Evaluator evaluator, ScopeChain previousScope, ESObject thisObject, String functionName, int hash, ESValue[] arguments) throws EcmaScriptException {
        if (functionName.equals("callee")) {
            return this.callee.callFunction(thisObject, arguments);
        }
        return super.doIndirectCallInScope(evaluator, previousScope, thisObject, functionName, hash, arguments);
    }

    public ESValue getProperty(String propertyName, int hash) throws EcmaScriptException {
        if (propertyName.equals("callee")) {
            return this.callee;
        }
        if (propertyName.equals("arguments")) {
            return this;
        }
        if (propertyName.equals("length")) {
            return new ESNumber(this.length);
        }
        if (super.hasProperty(propertyName, hash)) {
            return super.getProperty(propertyName, hash);
        }
        int index = -1;
        try {
            char c = propertyName.charAt(0);
            if ('0' <= c && c <= '9') {
                index = Integer.parseInt(propertyName);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (index >= 0 && index < this.argumentNames.length) {
            propertyName = this.argumentNames[index];
            hash = propertyName.hashCode();
        }
        return super.getProperty(propertyName, hash);
    }

    public ESValue getProperty(int index) throws EcmaScriptException {
        if (index >= 0 && index < this.argumentNames.length) {
            String propertyName = this.argumentNames[index];
            return super.getProperty(propertyName, propertyName.hashCode());
        }
        String iString = Integer.toString(index);
        return this.getProperty(iString, iString.hashCode());
    }

    public boolean hasProperty(String propertyName, int hash) throws EcmaScriptException {
        if (propertyName.equals("callee")) {
            return true;
        }
        if (propertyName.equals("arguments")) {
            return true;
        }
        if (propertyName.equals("length")) {
            return true;
        }
        if (super.hasProperty(propertyName, hash)) {
            return true;
        }
        int index = -1;
        try {
            char c = propertyName.charAt(0);
            if ('0' <= c && c <= '9') {
                index = Integer.parseInt(propertyName);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return index >= 0 && index < this.argumentNames.length;
    }

    public static ESArguments makeNewESArguments(Evaluator evaluator, ESObject callee, String[] argumentNames, ESValue[] argumentValues) {
        ObjectPrototype op = (ObjectPrototype)evaluator.getObjectPrototype();
        int maxArgs = Math.max(argumentValues.length, argumentNames.length);
        ESArguments args = new ESArguments(op, evaluator, argumentNames, maxArgs, callee);
        try {
            for (int i = 0; i < maxArgs; ++i) {
                ESUndefined val;
                ESValue eSValue = val = i < argumentValues.length ? argumentValues[i] : ESUndefined.theUndefined;
                if (i < argumentNames.length) {
                    args.putProperty(argumentNames[i], val, argumentNames[i].hashCode());
                    continue;
                }
                String iString = Integer.toString(i);
                args.putProperty(iString, val, iString.hashCode());
            }
        }
        catch (EcmaScriptException e) {
            e.printStackTrace();
            throw new ProgrammingError(e.getMessage());
        }
        return args;
    }

    public boolean deleteProperty(String propertyName, int hash) throws EcmaScriptException {
        return !this.hasProperty(propertyName, hash);
    }

    public ESValue getDefaultValue(Evaluator evaluator, int hint) throws EcmaScriptException {
        return this.callee.getDefaultValue(hint);
    }

    public int getTypeOf() {
        return this.callee.getTypeOf();
    }

    public Object toJavaObject() {
        return this.callee.toJavaObject();
    }

    public String getTypeofString() {
        return this.callee.getTypeofString();
    }

    public String toString() {
        return this.callee.toString();
    }

    public String toDetailString() {
        return this.callee.toDetailString();
    }

    public String[] getSpecialPropertyNames() {
        String[] ns = new String[]{"arguments", "callee", "length"};
        return ns;
    }
}

