/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DatePrototype
extends ESObject {
    protected Date date = null;

    DatePrototype(ESObject prototype, Evaluator evaluator) {
        super(prototype, evaluator);
        this.date = new Date();
    }

    public DatePrototype(Evaluator evaluator, Date aDate) {
        super(evaluator.getDatePrototype(), evaluator);
        this.date = new Date(aDate.getTime());
    }

    public DatePrototype(Evaluator evaluator, long time) {
        super(evaluator.getDatePrototype(), evaluator);
        this.date = new Date(time);
    }

    public String getESClassName() {
        return "Date";
    }

    public ESValue setYear(ESValue[] arguments) throws EcmaScriptException {
        if (this.date == null) {
            return new ESNumber(Double.NaN);
        }
        if (arguments.length <= 0) {
            this.date = null;
            return new ESNumber(Double.NaN);
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getDefault());
        cal.setTime(this.date);
        double d = arguments[0].doubleValue();
        if (Double.isNaN(d)) {
            this.date = null;
            return new ESNumber(Double.NaN);
        }
        if (d < 100.0) {
            d += 1900.0;
        }
        cal.set(1, (int)d);
        this.date = cal.getTime();
        long t = this.date.getTime();
        return new ESNumber(t);
    }

    public ESValue setTime(ESValue[] arguments, int[] argTypes) throws EcmaScriptException {
        if (this.date == null) {
            return new ESNumber(Double.NaN);
        }
        if (arguments.length <= 0) {
            this.date = null;
            return new ESNumber(Double.NaN);
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getDefault());
        cal.setTime(this.date);
        for (int iarg = 0; iarg < argTypes.length && iarg < arguments.length; ++iarg) {
            double d = arguments[iarg].doubleValue();
            if (Double.isNaN(d)) {
                this.date = null;
                return new ESNumber(Double.NaN);
            }
            cal.set(argTypes[iarg], (int)d);
        }
        this.date = cal.getTime();
        long t = this.date.getTime();
        return new ESNumber(t);
    }

    public ESValue setUTCTime(ESValue[] arguments, int[] argTypes) throws EcmaScriptException {
        if (this.date == null) {
            return new ESNumber(Double.NaN);
        }
        if (arguments.length <= 0) {
            this.date = null;
            return new ESNumber(Double.NaN);
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        cal.setTime(this.date);
        for (int iarg = 0; iarg < argTypes.length && iarg < arguments.length; ++iarg) {
            double d = arguments[iarg].doubleValue();
            if (Double.isNaN(d)) {
                this.date = null;
                return new ESNumber(Double.NaN);
            }
            cal.set(argTypes[iarg], (int)d);
        }
        this.date = cal.getTime();
        long t = this.date.getTime();
        return new ESNumber(t);
    }

    public ESValue get(int element) {
        if (this.date == null) {
            return new ESNumber(Double.NaN);
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getDefault());
        cal.setTime(this.date);
        long t = cal.get(element);
        if (element == 7) {
            --t;
        }
        return new ESNumber(t);
    }

    public ESValue getUTC(int element) {
        if (this.date == null) {
            return new ESNumber(Double.NaN);
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        cal.setTime(this.date);
        long t = cal.get(element);
        if (element == 7) {
            --t;
        }
        return new ESNumber(t);
    }

    public String toString() {
        return this.date == null ? "null" : this.date.toString();
    }

    public String toDetailString() {
        return "ES:[Object: builtin " + this.getClass().getName() + ":" + (this.date == null ? "null" : this.date.toString()) + "]";
    }

    public Object toJavaObject() {
        return this.date;
    }

    public ESValue getDefaultValue() throws EcmaScriptException {
        return this.getDefaultValue(5);
    }
}

