/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.AST.ASTStatementList;
import FESI.Data.ESArguments;
import FESI.Data.ESNull;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.ObjectObject;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.EvaluationSource;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.ScopeChain;
import java.util.Vector;

public class ConstructedFunctionObject
extends FunctionPrototype {
    private static final String PROTOTYPEstring = new String("prototype").intern();
    private static final int PROTOTYPEhash = PROTOTYPEstring.hashCode();
    private ASTStatementList theFunctionAST;
    private String[] theArguments;
    private Vector localVariableNames;
    private EvaluationSource evaluationSource = null;
    private String functionSource = null;
    private ESValue currentArguments = ESNull.theNull;

    private ConstructedFunctionObject(FunctionPrototype functionPrototype, Evaluator evaluator, String functionName, EvaluationSource evaluationSource, String functionSource, String[] arguments, Vector localVariableNames, ASTStatementList aFunctionAST) {
        super(functionPrototype, evaluator, functionName, arguments.length);
        this.evaluationSource = evaluationSource;
        this.functionSource = functionSource;
        this.theFunctionAST = aFunctionAST;
        this.theArguments = arguments;
        this.localVariableNames = localVariableNames;
    }

    public String getFunctionImplementationString() {
        if (this.functionSource == null) {
            StringBuffer str = new StringBuffer();
            str.append("function ");
            str.append(this.getFunctionName());
            str.append("(");
            for (int i = 0; i < this.theArguments.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(this.theArguments[i]);
            }
            str.append(")");
            str.append("function {<internal abstract syntax tree representation>}");
            return str.toString();
        }
        return this.functionSource;
    }

    public Vector getLocalVariableNames() {
        return this.localVariableNames;
    }

    public String getFunctionParametersString() {
        StringBuffer str = new StringBuffer();
        str.append("(");
        for (int i = 0; i < this.theArguments.length; ++i) {
            if (i > 0) {
                str.append(",");
            }
            str.append(this.theArguments[i]);
        }
        str.append(")");
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        ESValue value = null;
        ESArguments args = ESArguments.makeNewESArguments(this.evaluator, this, this.theArguments, arguments);
        ESValue oldArguments = this.currentArguments;
        this.currentArguments = args;
        try {
            value = this.evaluator.evaluateFunction(this.theFunctionAST, this.evaluationSource, args, this.localVariableNames, thisObject);
        }
        finally {
            this.currentArguments = oldArguments;
        }
        return value;
    }

    public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        ESValue prototype = this.getProperty(PROTOTYPEstring, PROTOTYPEhash);
        ESObject op = this.evaluator.getObjectPrototype();
        if (!(prototype instanceof ESObject)) {
            prototype = op;
        }
        ObjectPrototype obj = new ObjectPrototype((ESObject)prototype, this.evaluator);
        ESValue result = this.callFunction(obj, arguments);
        return obj;
    }

    public String toString() {
        return this.getFunctionImplementationString();
    }

    public String toDetailString() {
        StringBuffer str = new StringBuffer();
        str.append("<Function: ");
        str.append(this.getFunctionName());
        str.append("(");
        for (int i = 0; i < this.theArguments.length; ++i) {
            if (i > 0) {
                str.append(",");
            }
            str.append(this.theArguments[i]);
        }
        str.append(")>");
        return str.toString();
    }

    public static ConstructedFunctionObject makeNewConstructedFunction(Evaluator evaluator, String functionName, EvaluationSource evaluationSource, String sourceString, String[] arguments, Vector localVariableNames, ASTStatementList aFunctionAST) {
        ConstructedFunctionObject theNewFunction = null;
        try {
            FunctionPrototype fp = (FunctionPrototype)evaluator.getFunctionPrototype();
            theNewFunction = new ConstructedFunctionObject(fp, evaluator, functionName, evaluationSource, sourceString, arguments, localVariableNames, aFunctionAST);
            ObjectPrototype thePrototype = ObjectObject.createObject(evaluator);
            theNewFunction.putHiddenProperty("prototype", thePrototype);
            thePrototype.putHiddenProperty("constructor", theNewFunction);
        }
        catch (EcmaScriptException e) {
            e.printStackTrace();
            throw new ProgrammingError(e.getMessage());
        }
        return theNewFunction;
    }

    public ESValue getPropertyInScope(String propertyName, ScopeChain previousScope, int hash) throws EcmaScriptException {
        if (propertyName.equals("arguments")) {
            return this.currentArguments;
        }
        return super.getPropertyInScope(propertyName, previousScope, hash);
    }

    public ESValue getProperty(String propertyName, int hash) throws EcmaScriptException {
        if (propertyName.equals("arguments")) {
            return this.currentArguments;
        }
        return super.getProperty(propertyName, hash);
    }

    public boolean hasProperty(String propertyName, int hash) throws EcmaScriptException {
        if (propertyName.equals("arguments")) {
            return true;
        }
        return super.hasProperty(propertyName, hash);
    }

    public void putProperty(String propertyName, ESValue propertyValue, int hash) throws EcmaScriptException {
        if (!propertyName.equals("arguments")) {
            super.putProperty(propertyName, propertyValue, hash);
        }
    }
}

