/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESPrimitive;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.ScopeChain;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class ArrayPrototype
extends ESObject {
    private static final String LENGTHstring = "length".intern();
    private static final int LENGTHhash = LENGTHstring.hashCode();
    protected Vector theArray = new Vector();

    public ArrayPrototype(ESObject prototype, Evaluator evaluator) {
        super(prototype, evaluator);
    }

    public String getESClassName() {
        return "Array";
    }

    public Object toJavaArray(Class componentType) throws EcmaScriptException {
        int l = this.size();
        Object array = Array.newInstance(componentType, l);
        if (l == 0) {
            return array;
        }
        for (int i = 0; i < l; ++i) {
            ESValue element = (ESValue)this.theArray.elementAt(i);
            if (componentType == Integer.TYPE) {
                if (element.isNumberValue()) {
                    double d = element.doubleValue();
                    int value = (int)d;
                    if ((double)value != d) {
                        throw new EcmaScriptException("An element (" + element + ") of array is too large for class " + componentType);
                    }
                    Array.setInt(array, i, value);
                    continue;
                }
                throw new EcmaScriptException("An element (" + element + ") of array cannot be converted to class " + componentType);
            }
            if (componentType == Short.TYPE) {
                if (element.isNumberValue()) {
                    double d = element.doubleValue();
                    short value = (short)d;
                    if ((double)value != d) {
                        throw new EcmaScriptException("An element (" + element + ") of array is too large for class " + componentType);
                    }
                    Array.setShort(array, i, value);
                    continue;
                }
                throw new EcmaScriptException("An element (" + element + ") of array cannot be converted to class " + componentType);
            }
            if (componentType == Byte.TYPE) {
                if (element.isNumberValue()) {
                    double d = element.doubleValue();
                    byte value = (byte)d;
                    if ((double)value != d) {
                        throw new EcmaScriptException("An element (" + element + ") of array is too large for class " + componentType);
                    }
                    Array.setByte(array, i, value);
                    continue;
                }
                throw new EcmaScriptException("An element (" + element + ") of array cannot be converted to class " + componentType);
            }
            if (componentType == Long.TYPE) {
                if (element.isNumberValue()) {
                    double d = element.doubleValue();
                    long value = (long)d;
                    if ((double)value != d) {
                        throw new EcmaScriptException("An element (" + element + ") of array is too large for class " + componentType);
                    }
                    Array.setLong(array, i, value);
                    continue;
                }
                throw new EcmaScriptException("An element (" + element + ") of array cannot be converted to class " + componentType);
            }
            if (componentType == Float.TYPE) {
                if (element.isNumberValue()) {
                    double d = element.doubleValue();
                    float value = (float)d;
                    if ((double)value != d) {
                        throw new EcmaScriptException("An element (" + element + ") of array is too large for class " + componentType);
                    }
                    Array.setFloat(array, i, value);
                    continue;
                }
                throw new EcmaScriptException("An element (" + element + ") of array cannot be converted to class " + componentType);
            }
            if (componentType == Double.TYPE) {
                if (element.isNumberValue()) {
                    double d = element.doubleValue();
                    Array.setDouble(array, i, d);
                    continue;
                }
                throw new EcmaScriptException("An element (" + element + ") of array cannot be converted to class " + componentType);
            }
            if (componentType == Boolean.TYPE) {
                if (element.isBooleanValue()) {
                    boolean b = element.booleanValue();
                    Array.setBoolean(array, i, b);
                    continue;
                }
                throw new EcmaScriptException("An element (" + element + ") of array cannot be converted to class " + componentType);
            }
            if (componentType == Character.TYPE) {
                if (element.isStringValue()) {
                    String s = element.toString();
                    if (s.length() != 1) {
                        throw new EcmaScriptException("A string (" + element + ") of array is not of size 1 for conversion to Character");
                    }
                    Array.setChar(array, i, s.charAt(0));
                    continue;
                }
                throw new EcmaScriptException("An element (" + element + ") of array cannot be converted to class " + componentType);
            }
            Object o = element.toJavaObject();
            if (o == null) {
                Array.set(array, i, o);
                continue;
            }
            Class<?> sourceClass = o.getClass();
            if (componentType.isAssignableFrom(sourceClass)) {
                Array.set(array, i, o);
                continue;
            }
            throw new EcmaScriptException("An element (" + element + ") of array cannot be converted to class " + componentType);
        }
        return array;
    }

    public String toDetailString() {
        return "ES:[" + this.getESClassName() + ":" + this.getClass().getName() + "]";
    }

    public int size() {
        return this.theArray.size();
    }

    public void setSize(int size) {
        this.theArray.setSize(size);
    }

    public void setElementAt(ESValue theElement, int index) {
        this.theArray.setElementAt(theElement, index);
    }

    public ESValue reverse() throws EcmaScriptException {
        int size = this.theArray.size();
        if (size > 0) {
            Vector reversed = new Vector(size);
            reversed.setSize(size);
            int i = 0;
            int j = size - 1;
            while (i < size) {
                reversed.setElementAt(this.theArray.elementAt(j), i);
                ++i;
                --j;
            }
            this.theArray = reversed;
        }
        return this;
    }

    private void sort(int from, int to, Comparer c) throws EcmaScriptException {
        if (this.theArray.size() < 2) {
            return;
        }
        int i = from;
        int j = to;
        ESValue center = (ESValue)this.theArray.elementAt((from + to) / 2);
        do {
            ESValue ai = (ESValue)this.theArray.elementAt(i);
            ESValue aj = (ESValue)this.theArray.elementAt(j);
            while (i < to && c.compare(center, ai) > 0) {
                ai = (ESValue)this.theArray.elementAt(++i);
            }
            while (j > from && c.compare(center, aj) < 0) {
                aj = (ESValue)this.theArray.elementAt(--j);
            }
            if (i < j) {
                ESValue tmp = ai;
                this.theArray.setElementAt(aj, i);
                this.theArray.setElementAt(tmp, j);
            }
            if (i > j) continue;
            ++i;
            --j;
        } while (i <= j);
        if (from < j) {
            this.sort(from, j, c);
        }
        if (i < to) {
            this.sort(i, to, c);
        }
    }

    public ESValue sort(ESValue compareFn) throws EcmaScriptException {
        if (compareFn != null && !(compareFn instanceof FunctionPrototype)) {
            throw new EcmaScriptException("Compare function not a function: " + compareFn);
        }
        Comparer c = null;
        c = compareFn != null ? new FunctionComparer((FunctionPrototype)compareFn) : new DefaultComparer();
        this.sort(0, this.theArray.size() - 1, c);
        return this;
    }

    public void putProperty(String propertyName, ESValue propertyValue, int hash) throws EcmaScriptException {
        if (hash == LENGTHhash && propertyName.equals(LENGTHstring)) {
            int length = (int)((ESPrimitive)propertyValue).doubleValue();
            if (length < 0) {
                throw new EcmaScriptException("Invalid length value: " + propertyValue);
            }
            this.theArray.setSize(length);
        } else {
            int index = -1;
            try {
                index = Integer.parseInt(propertyName);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (index < 0) {
                super.putProperty(propertyName, propertyValue, hash);
            } else {
                this.putProperty(index, propertyValue);
            }
        }
    }

    public void putProperty(int index, ESValue propertyValue) throws EcmaScriptException {
        if (index >= this.theArray.size()) {
            this.theArray.setSize(index + 1);
        }
        this.theArray.setElementAt(propertyValue, index);
    }

    public ESValue getPropertyInScope(String propertyName, ScopeChain previousScope, int hash) throws EcmaScriptException {
        if (hash == LENGTHhash && propertyName.equals(LENGTHstring)) {
            return new ESNumber(this.theArray.size());
        }
        if (this.hasProperty(propertyName, hash)) {
            return this.getProperty(propertyName, hash);
        }
        if (previousScope == null) {
            throw new EcmaScriptException("global variable '" + propertyName + "' does not have a value");
        }
        return previousScope.getValue(propertyName, hash);
    }

    public ESValue getProperty(String propertyName, int hash) throws EcmaScriptException {
        if (hash == LENGTHhash && propertyName.equals(LENGTHstring)) {
            return new ESNumber(this.theArray.size());
        }
        int index = -1;
        try {
            index = Integer.parseInt(propertyName);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (index < 0) {
            return super.getProperty(propertyName, hash);
        }
        return this.getProperty(index);
    }

    public ESValue getProperty(int index) throws EcmaScriptException {
        Object theElement = null;
        if (index < this.theArray.size()) {
            theElement = this.theArray.elementAt(index);
        }
        if (theElement == null) {
            return ESUndefined.theUndefined;
        }
        return theElement;
    }

    public boolean hasProperty(String propertyName, int hash) throws EcmaScriptException {
        if (hash == LENGTHhash && propertyName.equals(LENGTHstring)) {
            return true;
        }
        int index = -1;
        try {
            index = Integer.parseInt(propertyName);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (index < 0) {
            return super.hasProperty(propertyName, hash);
        }
        return index < this.theArray.size();
    }

    public Enumeration getProperties() {
        return new Enumeration(){
            Enumeration props;
            Object currentKey;
            int currentHash;
            int nextIndex;
            boolean inside;
            ESObject prototype;
            {
                this.props = ArrayPrototype.this.properties.keys();
                this.currentKey = null;
                this.currentHash = 0;
                this.nextIndex = 0;
                this.inside = false;
                this.prototype = ArrayPrototype.this.getPrototype();
            }

            public boolean hasMoreElements() {
                if (this.currentKey != null) {
                    return true;
                }
                while (this.nextIndex < ArrayPrototype.this.theArray.size() && ArrayPrototype.this.theArray.elementAt(this.nextIndex) == null) {
                    ++this.nextIndex;
                }
                if (this.nextIndex < ArrayPrototype.this.theArray.size()) {
                    this.currentKey = new ESNumber(this.nextIndex++);
                    return true;
                }
                while (this.props.hasMoreElements()) {
                    this.currentKey = this.props.nextElement();
                    this.currentHash = this.currentKey.hashCode();
                    if (this.inside ? ArrayPrototype.this.properties.containsKey((String)this.currentKey, this.currentHash) : ArrayPrototype.this.isHiddenProperty((String)this.currentKey, this.currentHash)) continue;
                    return true;
                }
                if (!this.inside && this.prototype != null) {
                    this.inside = true;
                    this.props = this.prototype.getProperties();
                    while (this.props.hasMoreElements()) {
                        this.currentKey = this.props.nextElement();
                        this.currentHash = this.currentKey.hashCode();
                        if (ArrayPrototype.this.properties.containsKey((String)this.currentKey, this.currentHash)) continue;
                        return true;
                    }
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    Object key = this.currentKey;
                    this.currentKey = null;
                    return key;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Enumeration getAllProperties() {
        return new Enumeration(){
            String[] specialProperties;
            int specialEnumerator;
            Enumeration props;
            String currentKey;
            int currentHash;
            boolean inside;
            int nextIndex;
            {
                this.specialProperties = ArrayPrototype.this.getSpecialPropertyNames();
                this.specialEnumerator = 0;
                this.props = ArrayPrototype.this.properties.keys();
                this.currentKey = null;
                this.currentHash = 0;
                this.inside = false;
                this.nextIndex = 0;
            }

            public boolean hasMoreElements() {
                if (this.currentKey != null) {
                    return true;
                }
                if (this.nextIndex < ArrayPrototype.this.theArray.size()) {
                    while (this.nextIndex < ArrayPrototype.this.theArray.size() && ArrayPrototype.this.theArray.elementAt(this.nextIndex) == null) {
                        ++this.nextIndex;
                    }
                    if (this.nextIndex < ArrayPrototype.this.theArray.size()) {
                        this.currentKey = Integer.toString(this.nextIndex);
                        this.currentHash = this.currentKey.hashCode();
                        ++this.nextIndex;
                        return true;
                    }
                }
                if (this.specialEnumerator < this.specialProperties.length) {
                    this.currentKey = this.specialProperties[this.specialEnumerator];
                    this.currentHash = this.currentKey.hashCode();
                    ++this.specialEnumerator;
                    return true;
                }
                while (this.props.hasMoreElements()) {
                    this.currentKey = (String)this.props.nextElement();
                    this.currentHash = this.currentKey.hashCode();
                    if (this.inside && ArrayPrototype.this.properties.containsKey(this.currentKey, this.currentHash)) continue;
                    return true;
                }
                if (!this.inside && ArrayPrototype.this.getPrototype() != null) {
                    this.inside = true;
                    this.props = ArrayPrototype.this.getPrototype().getProperties();
                    while (this.props.hasMoreElements()) {
                        this.currentKey = (String)this.props.nextElement();
                        this.currentHash = this.currentKey.hashCode();
                        if (ArrayPrototype.this.properties.containsKey(this.currentKey, this.currentHash)) continue;
                        return true;
                    }
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    String key = this.currentKey;
                    this.currentKey = null;
                    return key;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public String[] getSpecialPropertyNames() {
        String[] ns = new String[]{LENGTHstring};
        return ns;
    }

    class FunctionComparer
    implements Comparer {
        FunctionPrototype compareFn;
        ESValue[] arguments;
        ESObject thisObject;

        public FunctionComparer(FunctionPrototype fn) {
            this.compareFn = fn;
            this.arguments = new ESValue[2];
            this.thisObject = ArrayPrototype.this.evaluator.getGlobalObject();
        }

        public int compare(ESValue v1, ESValue v2) throws EcmaScriptException {
            ESValue v1p = v1.toESPrimitive(4);
            ESValue v2p = v2.toESPrimitive(4);
            if (v1p == ESUndefined.theUndefined && v2p == ESUndefined.theUndefined) {
                return 0;
            }
            if (v1p == ESUndefined.theUndefined) {
                return 1;
            }
            if (v2p == ESUndefined.theUndefined) {
                return -1;
            }
            this.arguments[0] = v1;
            this.arguments[1] = v2;
            ESValue compValue = this.compareFn.callFunction(this.thisObject, this.arguments);
            return compValue.toInt32();
        }
    }

    static class DefaultComparer
    implements Comparer {
        DefaultComparer() {
        }

        public int compare(ESValue v1, ESValue v2) throws EcmaScriptException {
            ESValue v1p = v1.toESPrimitive(4);
            ESValue v2p = v2.toESPrimitive(4);
            if (v1p == ESUndefined.theUndefined && v2p == ESUndefined.theUndefined) {
                return 0;
            }
            if (v1p == ESUndefined.theUndefined) {
                return 1;
            }
            if (v2p == ESUndefined.theUndefined) {
                return -1;
            }
            String s1 = v1.toString();
            String s2 = v2.toString();
            return s1.compareTo(s2);
        }
    }

    static interface Comparer {
        public int compare(ESValue var1, ESValue var2) throws EcmaScriptException;
    }
}

