/*
 * Decompiled with CFR 0.152.
 */
package FESI.ClassFile;

import FESI.ClassFile.Attribute;
import FESI.ClassFile.ClassFile;
import FESI.ClassFile.UTF8Constant;
import java.io.DataOutputStream;
import java.io.IOException;

final class FieldDesc {
    static final short ACC_PUBLIC = 1;
    static final short ACC_PRIVATE = 2;
    static final short ACC_PROTECTED = 4;
    static final short ACC_STATIC = 8;
    static final short ACC_FINAL = 16;
    static final short ACC_VOLATILE = 64;
    static final short ACC_TRANSIENT = 128;
    private UTF8Constant name;
    private UTF8Constant descriptor;
    private short accessFlags;
    private ClassFile classFile;
    private Attribute[] attributes;

    FieldDesc(String field, String desc, short flags, ClassFile cf, Attribute[] attrs) {
        this.name = new UTF8Constant(field, cf);
        this.descriptor = new UTF8Constant(desc, cf);
        this.accessFlags = flags;
        this.classFile = cf;
        this.attributes = attrs;
    }

    void write(DataOutputStream dos) throws IOException {
        dos.writeShort(this.accessFlags);
        dos.writeShort(this.name.getConstantPoolIndex());
        dos.writeShort(this.descriptor.getConstantPoolIndex());
        if (this.attributes != null && this.attributes.length == 0) {
            dos.writeShort(this.attributes.length);
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i].write(dos);
            }
        } else {
            dos.writeShort(0);
        }
    }
}

