/*
 * Decompiled with CFR 0.152.
 */
package FESI.ClassFile;

import FESI.ClassFile.Attribute;
import FESI.ClassFile.ClassConstant;
import FESI.ClassFile.ClassFile;
import java.io.DataOutputStream;
import java.io.IOException;

class Exceptions
extends Attribute {
    private ClassConstant[] exceptions;

    Exceptions(ClassConstant[] exs, ClassFile cf) {
        super("Exceptions", cf);
        this.exceptions = exs;
    }

    Exceptions(Class[] exs, ClassFile cf) {
        super("Exceptions", cf);
        ClassConstant[] cc = new ClassConstant[exs.length];
        for (int i = 0; i < exs.length; ++i) {
            cc[i] = cf.addClassConstant(exs[i].getName());
        }
        this.exceptions = cc;
    }

    void write(DataOutputStream dos) throws IOException {
        dos.writeShort(this.getNameConstantPoolIndex());
        dos.writeInt(this.getLength());
        if (this.exceptions != null && this.exceptions.length > 0) {
            dos.writeShort(this.exceptions.length);
            for (int i = 0; i < this.exceptions.length; ++i) {
                dos.writeShort(this.exceptions[i].getConstantPoolIndex());
            }
        } else {
            dos.writeShort(0);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Exceptions) {
            Exceptions other = (Exceptions)o;
            if (this.exceptions.length == other.exceptions.length) {
                for (int i = 0; i < this.exceptions.length; ++i) {
                    if (this.exceptions[i].equals(other.exceptions[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    int getLength() {
        return this.exceptions.length * 2 + 2;
    }

    void addException(ClassConstant ex) {
        if (this.exceptions == null) {
            this.exceptions = new ClassConstant[1];
            this.exceptions[0] = ex;
        } else {
            ClassConstant[] temp = new ClassConstant[this.exceptions.length + 1];
            for (int i = 0; i < this.exceptions.length; ++i) {
                temp[i] = this.exceptions[i];
            }
            temp[i] = ex;
            this.exceptions = temp;
        }
    }
}

