/*
 * Decompiled with CFR 0.152.
 */
package FESI.ClassFile;

import FESI.ClassFile.Attribute;
import FESI.ClassFile.ClassConstant;
import FESI.ClassFile.ClassFile;
import FESI.ClassFile.Code;
import FESI.ClassFile.Exceptions;
import FESI.ClassFile.FieldConstant;
import FESI.ClassFile.FieldDesc;
import FESI.ClassFile.MethodConstant;
import FESI.ClassFile.MethodDesc;
import FESI.ClassFile.StringConstant;
import FESI.Interpreter.EventAdaptorGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;

public final class EventAdaptorClassFile {
    private static String superClassName = "FESI.Interpreter.EventAdaptor";
    private String listenerName;
    private Class listenerClass;
    private String adaptorName;
    private ClassFile classFile;
    private Method[] listenerMethods;
    private StringConstant listenerNameConst;
    private FieldConstant methodsField;
    private FieldConstant clazzField;
    private MethodConstant fireMethod;
    private MethodConstant crackedFireMethod;
    private MethodConstant forNameMethod;
    private MethodConstant getMethodsMethod;
    static /* synthetic */ Class class$java$util$EventObject;

    public EventAdaptorClassFile(String className, OutputStream os) throws IOException, ClassNotFoundException {
        this.adaptorName = className;
        this.listenerName = EventAdaptorGenerator.getBaseNameFromAdaptorName(className);
        this.listenerClass = Class.forName(this.listenerName);
        this.listenerMethods = this.listenerClass.getMethods();
        this.classFile = new ClassFile(className, superClassName);
        this.generateClassSundries();
        this.generateInitializer();
        this.generateConstructor();
        this.generateListenerMethods();
        this.write(os);
    }

    private boolean debug() {
        return false;
    }

    private void generateClassSundries() {
        this.classFile.addInterface(ClassFile.fullyQualifiedForm(this.listenerName));
        this.listenerNameConst = this.classFile.addStringConstant(this.listenerName);
        this.classFile.addFieldDesc(new FieldDesc("methods", "[Ljava/lang/reflect/Method;", 10, this.classFile, null));
        this.methodsField = this.classFile.addFieldConstant(this.adaptorName, "methods", "[Ljava/lang/reflect/Method;");
        this.getMethodsMethod = this.classFile.addMethodConstant("java/lang/Class", "getMethods", "()[Ljava/lang/reflect/Method;");
        this.forNameMethod = this.classFile.addMethodConstant("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        this.classFile.addFieldDesc(new FieldDesc("clazz", "Ljava/lang/Class;", 10, this.classFile, null));
        this.clazzField = this.classFile.addFieldConstant(this.adaptorName, "clazz", "Ljava/lang/Class;");
        this.fireMethod = this.classFile.addMethodConstant(this.adaptorName, "fire", "(Ljava/util/EventObject;Ljava/lang/reflect/Method;)V");
        this.crackedFireMethod = this.classFile.addMethodConstant(this.adaptorName, "fire", "([Ljava/lang/Object;Ljava/lang/reflect/Method;)V");
        Code c = new Code(this.classFile, 1, 2);
        c.addOpShort((byte)-78, this.clazzField.getConstantPoolIndex());
        c.addOp((byte)-80);
        Attribute[] ary = new Code[]{c};
        this.classFile.addMethodDesc(new MethodDesc("getListenerClass", "()Ljava/lang/Class;", 1, this.classFile, ary));
    }

    private void generateInitializer() {
        Code c = new Code(this.classFile, 0, 3);
        Attribute[] ary = new Code[]{c};
        short i = this.listenerNameConst.getConstantPoolIndex();
        if (i <= 255) {
            c.addOp1((byte)18, (byte)i);
        } else {
            c.addOpShort((byte)19, i);
        }
        c.addOpShort((byte)-72, this.forNameMethod.getConstantPoolIndex());
        c.addOp((byte)89);
        c.addOpShort((byte)-77, this.clazzField.getConstantPoolIndex());
        c.addOpShort((byte)-74, this.getMethodsMethod.getConstantPoolIndex());
        c.addOpShort((byte)-77, this.methodsField.getConstantPoolIndex());
        c.addOp((byte)-79);
        this.classFile.addMethodDesc(new MethodDesc("<clinit>", "()V", 10, this.classFile, ary));
    }

    private void generateConstructor() {
        Code c = new Code(this.classFile, 1, 2);
        Attribute[] ary = new Code[]{c};
        MethodConstant mc = this.classFile.addMethodConstant(ClassFile.fullyQualifiedForm(superClassName), "<init>", "()V");
        c.addOp((byte)42);
        c.addOpShort((byte)-73, mc.getConstantPoolIndex());
        c.addOp((byte)-79);
        this.classFile.addMethodDesc(new MethodDesc("<init>", "()V", 1, this.classFile, ary));
    }

    private void generateListenerMethods() {
        for (int i = 0; i < this.listenerMethods.length; ++i) {
            if (!Void.TYPE.equals(this.listenerMethods[i].getReturnType())) {
                System.err.println("Detected unexpected method signature: " + this.listenerMethods[i] + " in interface: " + this.listenerName);
                continue;
            }
            Class[] lmParams = this.listenerMethods[i].getParameterTypes();
            Class[] lmExceptions = this.listenerMethods[i].getExceptionTypes();
            if (lmParams != null && lmParams.length == 1 && (class$java$util$EventObject == null ? EventAdaptorClassFile.class$("java.util.EventObject") : class$java$util$EventObject).isAssignableFrom(lmParams[0])) {
                this.generateSimpleListenerMethodStub(this.listenerMethods[i], lmParams[0], lmExceptions, i);
                continue;
            }
            this.generateCrackedListenerMethodStub(this.listenerMethods[i], lmParams, lmExceptions, i);
        }
    }

    private void generateSimpleListenerMethodStub(Method listenerMethod, Class listenerParam, Class[] listenerExceptions, int listenerMethodTableIndex) {
        Attribute[] ary;
        Code c = new Code(this.classFile, 2, 4);
        c.addOp((byte)42);
        c.addOp((byte)43);
        c.addOpShort((byte)-78, this.methodsField.getConstantPoolIndex());
        if (listenerMethodTableIndex <= 255) {
            c.addOp1((byte)16, (byte)listenerMethodTableIndex);
        } else {
            short i = this.classFile.addIntegerConstant(listenerMethodTableIndex).getConstantPoolIndex();
            if (i <= 255) {
                c.addOp1((byte)18, (byte)i);
            } else {
                c.addOpShort((byte)19, i);
            }
        }
        c.addOp((byte)50);
        c.addOpShort((byte)-74, this.fireMethod.getConstantPoolIndex());
        c.addOp((byte)-79);
        if (listenerExceptions != null && listenerExceptions.length > 0) {
            ary = new Attribute[2];
            ary[1] = new Exceptions(listenerExceptions, this.classFile);
        } else {
            ary = new Attribute[]{c};
        }
        this.classFile.addMethodDesc(new MethodDesc(listenerMethod.getName(), "(" + ClassFile.fieldType(listenerParam.getName()) + ")V", (short)(listenerMethod.getModifiers() & 0xFFFFFBFF), this.classFile, ary));
    }

    private void generateCrackedListenerMethodStub(Method listenerMethod, Class[] listenerParams, Class[] listenerExceptions, int listenerMethodTableIndex) {
        Attribute[] ary;
        Code c = new Code(this.classFile, (short)(listenerParams.length * 2 + 1), 9);
        String methodPDesc = "";
        c.addOp((byte)42);
        if (listenerParams.length <= 255) {
            c.addOp1((byte)16, (byte)listenerParams.length);
        } else {
            short i = this.classFile.addIntegerConstant(listenerParams.length).getConstantPoolIndex();
            if (i <= 255) {
                c.addOp1((byte)18, (byte)i);
            } else {
                c.addOpShort((byte)19, i);
            }
        }
        c.addOpShort((byte)-67, this.classFile.addClassConstant("java.lang.Object").getConstantPoolIndex());
        int lvarIdx = 1;
        int i = 0;
        while (i < listenerParams.length) {
            c.addOp((byte)89);
            if (lvarIdx <= 255) {
                c.addOp1((byte)16, (byte)i);
            } else {
                short ic = this.classFile.addIntegerConstant(i).getConstantPoolIndex();
                if (ic < 255) {
                    c.addOp1((byte)18, (byte)ic);
                } else {
                    c.addOpShort((byte)19, ic);
                }
            }
            String s = this.processParam(c, listenerParams[i], lvarIdx);
            c.addOp((byte)83);
            boolean wasDoubleWord = s.equals("J") || s.equals("D");
            methodPDesc = methodPDesc + s;
            ++i;
            lvarIdx += wasDoubleWord ? 2 : 1;
        }
        c.addOpShort((byte)-78, this.methodsField.getConstantPoolIndex());
        if (listenerMethodTableIndex <= 255) {
            c.addOp1((byte)16, (byte)listenerMethodTableIndex);
        } else {
            i = this.classFile.addIntegerConstant(listenerMethodTableIndex).getConstantPoolIndex();
            if (i <= 255) {
                c.addOp1((byte)18, (byte)i);
            } else {
                c.addOpShort((byte)19, (short)i);
            }
        }
        c.addOp((byte)50);
        c.addOpShort((byte)-74, this.crackedFireMethod.getConstantPoolIndex());
        c.addOp((byte)-79);
        if (listenerExceptions != null && listenerExceptions.length > 0) {
            ary = new Attribute[2];
            ary[1] = new Exceptions(listenerExceptions, this.classFile);
        } else {
            ary = new Attribute[]{c};
        }
        this.classFile.addMethodDesc(new MethodDesc(listenerMethod.getName(), "(" + methodPDesc + ")V", (short)(listenerMethod.getModifiers() & 0xFFFFFBFF), this.classFile, ary));
    }

    private String processParam(Code c, Class pClass, int pIdx) {
        ClassConstant cc = null;
        MethodConstant mc = null;
        int ldOpCode = 25;
        int convOpCode = 0;
        boolean singleWordParam = true;
        Class<?> pType = pClass;
        String pDesc = "";
        while (pType.isArray()) {
            pType = pType.getComponentType();
            pDesc = pDesc + "[";
        }
        boolean isPrimitive = pType.isPrimitive();
        boolean isArrayRef = pClass.isArray();
        if (isPrimitive) {
            if (pType.equals(Long.TYPE)) {
                pDesc = pDesc + "J";
                if (!isArrayRef) {
                    cc = this.classFile.addClassConstant("java/lang/Long");
                    mc = this.classFile.addMethodConstant("java/lang/Long", "<init>", "(J)V");
                    ldOpCode = 22;
                    singleWordParam = false;
                }
            } else if (pType.equals(Float.TYPE)) {
                pDesc = pDesc + "F";
                if (!isArrayRef) {
                    cc = this.classFile.addClassConstant("java/lang/Float");
                    mc = this.classFile.addMethodConstant("java/lang/Float", "<init>", "(F)V");
                    ldOpCode = 23;
                }
            } else if (pType.equals(Double.TYPE)) {
                pDesc = pDesc + "D";
                if (!isArrayRef) {
                    cc = this.classFile.addClassConstant("java/lang/Double");
                    mc = this.classFile.addMethodConstant("java/lang/Double", "<init>", "(D)V");
                    ldOpCode = 24;
                    singleWordParam = false;
                }
            } else {
                ldOpCode = 21;
                if (pType.equals(Boolean.TYPE)) {
                    pDesc = pDesc + "Z";
                    if (!isArrayRef) {
                        cc = this.classFile.addClassConstant("java/lang/Boolean");
                        mc = this.classFile.addMethodConstant("java/lang/Boolean", "<init>", "(Z)V");
                        convOpCode = -111;
                    }
                } else if (pType.equals(Character.TYPE)) {
                    pDesc = pDesc + "C";
                    if (!isArrayRef) {
                        cc = this.classFile.addClassConstant("java/lang/Character");
                        mc = this.classFile.addMethodConstant("java/lang/Character", "<init>", "(C)V");
                        convOpCode = -110;
                    }
                } else if (pType.equals(Byte.TYPE)) {
                    pDesc = pDesc + "B";
                    if (!isArrayRef) {
                        cc = this.classFile.addClassConstant("java/lang/Byte");
                        mc = this.classFile.addMethodConstant("java/lang/Character", "<init>", "(C)V");
                        convOpCode = -111;
                    }
                } else if (pType.equals(Short.TYPE)) {
                    pDesc = pDesc + "S";
                    if (!isArrayRef) {
                        cc = this.classFile.addClassConstant("java/lang/Short");
                        mc = this.classFile.addMethodConstant("java/lang/Short", "<init>", "(S)V");
                        convOpCode = -109;
                    }
                } else if (pType.equals(Integer.TYPE)) {
                    pDesc = pDesc + "I";
                    if (!isArrayRef) {
                        cc = this.classFile.addClassConstant("java/lang/Integer");
                        mc = this.classFile.addMethodConstant("java/lang/Integer", "<init>", "(I)V");
                    }
                }
            }
        } else {
            pDesc = pDesc + ClassFile.fieldType(pType.getName());
        }
        if (pIdx < 255) {
            c.addOp1((byte)ldOpCode, (byte)pIdx);
        } else {
            c.addOp((byte)-60);
            c.addOpShort((byte)ldOpCode, (short)pIdx);
        }
        if (isPrimitive && !isArrayRef) {
            if (convOpCode != 0) {
                c.addOp((byte)convOpCode);
            }
            c.addOpShort((byte)-69, cc.getConstantPoolIndex());
            if (singleWordParam) {
                c.addOp((byte)90);
                c.addOp((byte)95);
            } else {
                c.addOp((byte)91);
                c.addOp((byte)91);
                c.addOp((byte)87);
            }
            c.addOpShort((byte)-73, mc.getConstantPoolIndex());
        }
        return pDesc;
    }

    private void write(OutputStream os) throws IOException {
        this.classFile.write(os);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

