/*
 * Decompiled with CFR 0.152.
 */
package FESI.ClassFile;

import FESI.ClassFile.Attribute;
import FESI.ClassFile.ClassConstant;
import FESI.ClassFile.ClassFile;
import FESI.ClassFile.ExceptionTableEntry;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

final class Code
extends Attribute {
    static final byte OP_NOP = 0;
    static final byte OP_ACONST_NULL = 1;
    static final byte OP_ICONST_m1 = 2;
    static final byte OP_ICONST_0 = 3;
    static final byte OP_ICONST_1 = 4;
    static final byte OP_ICONST_2 = 5;
    static final byte OP_ICONST_3 = 6;
    static final byte OP_ICONST_4 = 7;
    static final byte OP_ICONST_5 = 8;
    static final byte OP_LCONST_0 = 9;
    static final byte OP_LCONST_1 = 10;
    static final byte OP_FCONST_0 = 11;
    static final byte OP_FCONST_1 = 12;
    static final byte OP_FCONST_2 = 13;
    static final byte OP_DCONST_0 = 14;
    static final byte OP_DCONST_1 = 15;
    static final byte OP_BIPUSH = 16;
    static final byte OP_SIPUSH = 17;
    static final byte OP_LDC = 18;
    static final byte OP_LDC_WIDE = 19;
    static final byte OP_LDC2_WIDE = 20;
    static final byte OP_ILOAD = 21;
    static final byte OP_LLOAD = 22;
    static final byte OP_FLOAD = 23;
    static final byte OP_DLOAD = 24;
    static final byte OP_ALOAD = 25;
    static final byte OP_ILOAD_0 = 26;
    static final byte OP_ILOAD_1 = 27;
    static final byte OP_ILOAD_2 = 28;
    static final byte OP_ILOAD_3 = 29;
    static final byte OP_LLOAD_0 = 30;
    static final byte OP_LLOAD_1 = 31;
    static final byte OP_LLOAD_2 = 32;
    static final byte OP_LLOAD_3 = 33;
    static final byte OP_FLOAD_0 = 34;
    static final byte OP_FLOAD_1 = 35;
    static final byte OP_FLOAD_2 = 36;
    static final byte OP_FLOAD_3 = 37;
    static final byte OP_DLOAD_0 = 38;
    static final byte OP_DLOAD_1 = 39;
    static final byte OP_DLOAD_2 = 40;
    static final byte OP_DLOAD_3 = 41;
    static final byte OP_ALOAD_0 = 42;
    static final byte OP_ALOAD_1 = 43;
    static final byte OP_ALOAD_2 = 44;
    static final byte OP_ALOAD_3 = 45;
    static final byte OP_IALOAD = 46;
    static final byte OP_LALOAD = 47;
    static final byte OP_FALOAD = 48;
    static final byte OP_DALOAD = 49;
    static final byte OP_AALOAD = 50;
    static final byte OP_BALOAD = 51;
    static final byte OP_CALOAD = 52;
    static final byte OP_SALOAD = 53;
    static final byte OP_ISTORE = 54;
    static final byte OP_LSTORE = 55;
    static final byte OP_FSTORE = 56;
    static final byte OP_DSTORE = 57;
    static final byte OP_ASTORE = 58;
    static final byte OP_ISTORE_0 = 59;
    static final byte OP_ISTORE_1 = 60;
    static final byte OP_ISTORE_2 = 61;
    static final byte OP_ISTORE_3 = 62;
    static final byte OP_LSTORE_0 = 63;
    static final byte OP_LSTORE_1 = 64;
    static final byte OP_LSTORE_2 = 65;
    static final byte OP_LSTORE_3 = 66;
    static final byte OP_FSTORE_0 = 67;
    static final byte OP_FSTORE_1 = 68;
    static final byte OP_FSTORE_2 = 69;
    static final byte OP_FSTORE_3 = 70;
    static final byte OP_DSTORE_0 = 71;
    static final byte OP_DSTORE_1 = 72;
    static final byte OP_DSTORE_2 = 73;
    static final byte OP_DSTORE_3 = 74;
    static final byte OP_ASTORE_0 = 75;
    static final byte OP_ASTORE_1 = 76;
    static final byte OP_ASTORE_2 = 77;
    static final byte OP_ASTORE_3 = 78;
    static final byte OP_IASTORE = 79;
    static final byte OP_LASTORE = 80;
    static final byte OP_FASTORE = 81;
    static final byte OP_DASTORE = 82;
    static final byte OP_AASTORE = 83;
    static final byte OP_BASTORE = 84;
    static final byte OP_CASTORE = 85;
    static final byte OP_SASTORE = 86;
    static final byte OP_POP = 87;
    static final byte OP_POP2 = 88;
    static final byte OP_DUP = 89;
    static final byte OP_DUP_X1 = 90;
    static final byte OP_DUP_X2 = 91;
    static final byte OP_DUP2 = 92;
    static final byte OP_DUP2_X1 = 93;
    static final byte OP_DUP2_X2 = 94;
    static final byte OP_SWAP = 95;
    static final byte OP_IADD = 96;
    static final byte OP_LADD = 97;
    static final byte OP_FADD = 98;
    static final byte OP_DADD = 99;
    static final byte OP_ISUB = 100;
    static final byte OP_LSUB = 101;
    static final byte OP_FSUB = 102;
    static final byte OP_DSUB = 103;
    static final byte OP_IMUL = 104;
    static final byte OP_LMUL = 105;
    static final byte OP_FMUL = 106;
    static final byte OP_DMUL = 107;
    static final byte OP_IDIV = 108;
    static final byte OP_FDIV = 110;
    static final byte OP_LDIV = 109;
    static final byte OP_DDIV = 111;
    static final byte OP_IREM = 112;
    static final byte OP_LREM = 113;
    static final byte OP_FREM = 114;
    static final byte OP_DREM = 115;
    static final byte OP_INEG = 116;
    static final byte OP_LNEG = 117;
    static final byte OP_FNEG = 118;
    static final byte OP_DNEG = 119;
    static final byte OP_ISHL = 120;
    static final byte OP_LSHL = 121;
    static final byte OP_ISHR = 122;
    static final byte OP_LSHR = 123;
    static final byte OP_IUSHR = 124;
    static final byte OP_LUSHR = 125;
    static final byte OP_IAND = 126;
    static final byte OP_LAND = 127;
    static final byte OP_IOR = -128;
    static final byte OP_LOR = -127;
    static final byte OP_IXOR = -126;
    static final byte OP_LXOR = -125;
    static final byte OP_IINC = -124;
    static final byte OP_I2L = -123;
    static final byte OP_I2F = -122;
    static final byte OP_I2D = -121;
    static final byte OP_L2I = -120;
    static final byte OP_L2F = -119;
    static final byte OP_L2D = -118;
    static final byte OP_F2I = -117;
    static final byte OP_F2L = -116;
    static final byte OP_F2D = -115;
    static final byte OP_D2I = -114;
    static final byte OP_D2L = -113;
    static final byte OP_D2F = -112;
    static final byte OP_I2B = -111;
    static final byte OP_I2C = -110;
    static final byte OP_I2S = -109;
    static final byte OP_LCMP = -108;
    static final byte OP_FCMPL = -107;
    static final byte OP_FCMPG = -106;
    static final byte OP_DCMPL = -105;
    static final byte OP_DCMPG = -104;
    static final byte OP_IFEQ = -103;
    static final byte OP_IFNE = -102;
    static final byte OP_IFLT = -101;
    static final byte OP_IFGE = -100;
    static final byte OP_IFGT = -99;
    static final byte OP_IFLE = -98;
    static final byte OP_IFICMPEQ = -97;
    static final byte OP_IFICMPNE = -96;
    static final byte OP_IFICMPLT = -95;
    static final byte OP_IFICMPGE = -94;
    static final byte OP_IFICMPGT = -93;
    static final byte OP_IFICMPLE = -92;
    static final byte OP_IFACMPEQ = -91;
    static final byte OP_IFACMPNE = -90;
    static final byte OP_GOTO = -89;
    static final byte OP_JSR = -88;
    static final byte OP_RET = -87;
    static final byte OP_TABLESWITCH = -86;
    static final byte OP_LOOKUP_SWITCH = -85;
    static final byte OP_IRETURN = -84;
    static final byte OP_LRETURN = -83;
    static final byte OP_FRETURN = -82;
    static final byte OP_DRETURN = -81;
    static final byte OP_ARETURN = -80;
    static final byte OP_RETURN = -79;
    static final byte OP_GETSTATIC = -78;
    static final byte OP_GETFIELD = -76;
    static final byte OP_INVOKE_VIRTUAL = -74;
    static final byte OP_INVOKE_STATIC = -72;
    static final byte OP_INVOKE_SPECIAL = -73;
    static final byte OP_INVOKE_INTERFACE = -71;
    static final byte OP_NEW = -69;
    static final byte OP_NEWARRAY = -67;
    static final byte ARRAY_T_BOOLEAN = 4;
    static final byte ARRAY_T_CHAR = 5;
    static final byte ARRAY_T_FLOAT = 6;
    static final byte ARRAY_T_DOUBLE = 7;
    static final byte ARRAY_T_BYTE = 8;
    static final byte ARRAY_T_SHORT = 9;
    static final byte ARRAY_T_INT = 10;
    static final byte ARRAY_T_LONG = 11;
    static final byte OP_PUTSTATIC = -77;
    static final byte OP_PUTFIELD = -75;
    static final byte OP_ANEWARRAY = -67;
    static final byte OP_ARRAYLENGTH = -66;
    static final byte OP_ATHROW = -65;
    static final byte OP_CHECKCAST = -64;
    static final byte OP_INSTANCEOF = -63;
    static final byte OP_MONITOR_ENTER = -62;
    static final byte OP_MONITOR_EXIT = -61;
    static final byte OP_WIDE = -60;
    static final byte OP_MULTI_NEW_ARRAY = -59;
    static final byte OP_IFNULL = -58;
    static final byte OP_IFNONNULL = -57;
    static final byte OP_GOTO_WIDE = -56;
    static final byte OP_JSR_WIDE = -55;
    private Vector attributes;
    private int length = 12;
    private short currentPC;
    private short maxLocals;
    private short maxStack;
    private Vector byteCodes = new Vector(1);
    private Vector exceptions;

    Code(ClassFile cf, short locals, short stack) {
        super("Code", cf);
        this.maxLocals = locals >= 0 ? locals : (short)0;
        this.maxStack = (short)(stack > 2 ? stack : 2);
    }

    void write(DataOutputStream dos) throws IOException {
        int i;
        dos.writeShort(this.getNameConstantPoolIndex());
        dos.writeInt(this.getLength());
        dos.writeShort(this.maxStack);
        dos.writeShort(this.maxLocals);
        dos.writeInt(this.byteCodes.size());
        for (i = 0; i < this.byteCodes.size(); ++i) {
            dos.writeByte(((Byte)this.byteCodes.elementAt(i)).byteValue());
        }
        if (this.exceptions != null) {
            dos.writeShort(this.exceptions.size());
            for (i = 0; i < this.exceptions.size(); ++i) {
                ((ExceptionTableEntry)this.exceptions.elementAt(i)).write(dos);
            }
        } else {
            dos.writeShort(0);
        }
        if (this.attributes != null) {
            dos.writeShort(this.attributes.size());
            for (i = 0; i < this.attributes.size(); ++i) {
                ((Attribute)this.attributes.elementAt(i)).write(dos);
            }
        } else {
            dos.writeShort(0);
        }
    }

    int getLength() {
        return this.length;
    }

    public boolean equals(Object o) {
        return ((Object)this).equals(o);
    }

    short getCurrentPC() {
        return this.currentPC;
    }

    void addAttribute(Attribute attr) {
        if (this.attributes == null) {
            this.attributes = new Vector(1);
        }
        this.attributes.addElement(attr);
        this.length += attr.getLength() + 6;
    }

    void addExceptionTableEntry(short start, short stop, short handler, ClassConstant ct) {
        this.exceptions.addElement(new ExceptionTableEntry(start, stop, handler, ct));
        this.length += 8;
    }

    void addOp(byte opCode) {
        this.byteCodes.addElement(new Byte(opCode));
        this.currentPC = (short)(this.currentPC + 1);
        ++this.length;
    }

    void addOp1(byte opCode, byte op1) {
        this.byteCodes.addElement(new Byte(opCode));
        this.byteCodes.addElement(new Byte(op1));
        this.currentPC = (short)(this.currentPC + 2);
        this.length += 2;
    }

    void addOp2(byte opCode, byte op1, byte op2) {
        this.byteCodes.addElement(new Byte(opCode));
        this.byteCodes.addElement(new Byte(op1));
        this.byteCodes.addElement(new Byte(op2));
        this.currentPC = (short)(this.currentPC + 3);
        this.length += 3;
    }

    void addOp4(byte opCode, byte op1, byte op2, byte op3, byte op4) {
        this.byteCodes.addElement(new Byte(opCode));
        this.byteCodes.addElement(new Byte(op1));
        this.byteCodes.addElement(new Byte(op2));
        this.byteCodes.addElement(new Byte(op3));
        this.byteCodes.addElement(new Byte(op4));
        this.currentPC = (short)(this.currentPC + 5);
        this.length += 5;
    }

    void addOpShort(byte opCode, short op) {
        this.addOp2(opCode, (byte)(op >>> 8 & 0xFF), (byte)(op & 0xFF));
    }

    void addOpInt(byte opCode, int op) {
        this.addOp4(opCode, (byte)(op >>> 24 & 0xFF), (byte)(op >>> 16 & 0xFF), (byte)(op >>> 8 & 0xFF), (byte)(op & 0xFF));
    }

    void incrLocals(short n) {
        this.maxLocals = (short)(this.maxLocals + n);
    }

    void incrMaxStack(short n) {
        this.maxStack = (short)(this.maxStack + n);
    }
}

