/*
 * Decompiled with CFR 0.152.
 */
package FESI.ClassFile;

import FESI.ClassFile.Attribute;
import FESI.ClassFile.ClassConstant;
import FESI.ClassFile.ConstantPoolEntry;
import FESI.ClassFile.FieldConstant;
import FESI.ClassFile.FieldDesc;
import FESI.ClassFile.IntegerConstant;
import FESI.ClassFile.MethodConstant;
import FESI.ClassFile.MethodDesc;
import FESI.ClassFile.StringConstant;
import FESI.ClassFile.UTF8Constant;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

final class ClassFile {
    private static final int MAGIC = -889275714;
    private static final short MAJOR = 45;
    private static final short MINOR = 3;
    static final short ACC_PUBLIC = 1;
    static final short ACC_FINAL = 16;
    static final short ACC_SUPER = 32;
    static final short ACC_INTERFACE = 512;
    static final short ACC_ABSTRACT = 1024;
    private Vector constantPool = new Vector(1);
    private short accessFlags = (short)33;
    private ClassConstant thisClass;
    private ClassConstant superClass;
    private Vector interfaces;
    private Vector fields;
    private Vector methods;
    private Vector attributes;

    static boolean debug() {
        return false;
    }

    ClassFile(String tClass, String sClass) {
        this.thisClass = this.addClassConstant(tClass);
        this.superClass = this.addClassConstant(sClass);
    }

    private void writeConstantPool(DataOutputStream dos) throws IOException {
        if (ClassFile.debug()) {
            System.err.println("write constant pool: " + this.constantPool.size());
        }
        dos.writeShort(this.constantPool.size() + 1);
        for (int i = 0; i < this.constantPool.size(); ++i) {
            ((ConstantPoolEntry)this.constantPool.elementAt(i)).write(dos);
        }
    }

    private void writeInterfaces(DataOutputStream dos) throws IOException {
        if (this.interfaces != null) {
            if (ClassFile.debug()) {
                System.err.println("write interfaces: " + this.interfaces.size());
            }
            dos.writeShort(this.interfaces.size());
            for (int i = 0; i < this.interfaces.size(); ++i) {
                dos.writeShort(((ConstantPoolEntry)this.interfaces.elementAt(i)).getConstantPoolIndex());
            }
        } else {
            dos.writeShort(0);
        }
    }

    private void writeFields(DataOutputStream dos) throws IOException {
        if (this.fields != null) {
            if (ClassFile.debug()) {
                System.err.println("write fields: " + this.fields.size());
            }
            dos.writeShort(this.fields.size());
            for (int i = 0; i < this.fields.size(); ++i) {
                ((FieldDesc)this.fields.elementAt(i)).write(dos);
            }
        } else {
            dos.writeShort(0);
        }
    }

    private void writeMethods(DataOutputStream dos) throws IOException {
        if (this.methods != null) {
            if (ClassFile.debug()) {
                System.err.println("write methods: " + this.methods.size());
            }
            dos.writeShort(this.methods.size());
            for (int i = 0; i < this.methods.size(); ++i) {
                ((MethodDesc)this.methods.elementAt(i)).write(dos);
            }
        } else {
            dos.writeShort(0);
        }
    }

    private void writeAttributes(DataOutputStream dos) throws IOException {
        if (this.attributes != null) {
            if (ClassFile.debug()) {
                System.err.println("write attributes: " + this.attributes.size());
            }
            dos.writeShort(this.attributes.size());
            for (int i = 0; i < this.attributes.size(); ++i) {
                ((Attribute)this.attributes.elementAt(i)).write(dos);
            }
        } else {
            dos.writeShort(0);
        }
    }

    public synchronized void write(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        try {
            dos.writeInt(-889275714);
            dos.writeShort(3);
            dos.writeShort(45);
            this.writeConstantPool(dos);
            if (ClassFile.debug()) {
                System.err.println("access: " + this.accessFlags);
            }
            dos.writeShort(this.accessFlags);
            dos.writeShort(this.thisClass.getConstantPoolIndex());
            dos.writeShort(this.superClass.getConstantPoolIndex());
            this.writeInterfaces(dos);
            this.writeFields(dos);
            this.writeMethods(dos);
            this.writeAttributes(dos);
            dos.close();
        }
        catch (IOException ioe) {
            System.err.println("Bad IO");
        }
        catch (Exception e) {
            System.err.println("Oops");
        }
    }

    public synchronized short addConstantPoolEntry(ConstantPoolEntry cpe) {
        if (!this.constantPool.contains(cpe)) {
            this.constantPool.addElement(cpe);
        }
        return (short)(this.constantPool.indexOf(cpe) + 1);
    }

    synchronized ConstantPoolEntry match(byte tag, Object value) {
        for (int i = 0; i < this.constantPool.size(); ++i) {
            ConstantPoolEntry cpe = (ConstantPoolEntry)this.constantPool.elementAt(i);
            if (cpe.getTag() != tag || !cpe.equals(value)) continue;
            return cpe;
        }
        return null;
    }

    public synchronized short getAccessFlags() {
        return this.accessFlags;
    }

    public synchronized void setAccessFlags(short newf) {
        this.accessFlags = newf;
    }

    public synchronized void addMethodDesc(MethodDesc newMethod) {
        if (this.methods == null) {
            this.methods = new Vector(1);
        }
        this.methods.addElement(newMethod);
    }

    public synchronized void addFieldDesc(FieldDesc newField) {
        if (this.fields == null) {
            this.fields = new Vector(1);
        }
        this.fields.addElement(newField);
    }

    public StringConstant addStringConstant(String sConstant) {
        UTF8Constant c = (UTF8Constant)this.match((byte)1, sConstant);
        if (c == null) {
            c = new UTF8Constant(sConstant, this);
        }
        StringConstant s = new StringConstant(c, this);
        return s;
    }

    public IntegerConstant addIntegerConstant(int iConstant) {
        IntegerConstant c = (IntegerConstant)this.match((byte)3, new Integer(iConstant));
        if (c == null) {
            c = new IntegerConstant(iConstant, this);
        }
        return c;
    }

    public UTF8Constant addUTF8Constant(String sConstant) {
        UTF8Constant c = (UTF8Constant)this.match((byte)1, sConstant);
        if (c == null) {
            c = new UTF8Constant(sConstant, this);
        }
        return c;
    }

    public ClassConstant addClassConstant(String classConstant) {
        ClassConstant c = (ClassConstant)this.match((byte)7, classConstant);
        if (c == null) {
            c = new ClassConstant(classConstant, this);
        }
        return c;
    }

    public MethodConstant addMethodConstant(String cName, String mName, String tName) {
        return new MethodConstant(cName, mName, tName, this);
    }

    public FieldConstant addFieldConstant(String cName, String fName, String tName) {
        return new FieldConstant(cName, fName, tName, this);
    }

    public void addInterface(String iName) {
        if (this.interfaces == null) {
            this.interfaces = new Vector(1);
        }
        this.interfaces.addElement(this.addClassConstant(iName));
    }

    public static String fullyQualifiedForm(String str) {
        return str.replace('.', '/');
    }

    public static String fieldType(String str) {
        return "L" + ClassFile.fullyQualifiedForm(str) + ";";
    }
}

