/*
 * Decompiled with CFR 0.152.
 */
package FESI.ClassFile;

import FESI.ClassFile.ClassFile;
import FESI.ClassFile.ConstantPoolEntry;
import FESI.ClassFile.UTF8Constant;
import java.io.DataOutputStream;
import java.io.IOException;

class ClassConstant
extends ConstantPoolEntry {
    private UTF8Constant name;

    ClassConstant(String className, ClassFile cf) {
        super((byte)7, cf);
        this.name = cf.addUTF8Constant(ClassFile.fullyQualifiedForm(className));
        this.addToConstantPool();
    }

    void write(DataOutputStream dos) throws IOException {
        if (ClassConstant.debug()) {
            System.err.println(this.getConstantPoolIndex() + " CLASS: " + this.name.getConstantPoolIndex());
        }
        dos.writeByte(this.getTag());
        dos.writeShort(this.name.getConstantPoolIndex());
    }

    String getClassName() {
        return this.name.getString();
    }

    Class getClassObject() throws ClassNotFoundException {
        return Class.forName(this.name.getString());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof String) {
            return ((String)o).equals(this.name.getString());
        }
        if (o instanceof ClassConstant) {
            ClassConstant cc = (ClassConstant)o;
            return this.name.getString().equals(cc.getClassName());
        }
        return false;
    }
}

