/*
 * Decompiled with CFR 0.152.
 */
package FESI.Bsf;

import FESI.jslib.JSException;
import FESI.jslib.JSGlobalObject;
import FESI.jslib.JSObject;
import FESI.jslib.JSUtil;
import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.BSFFunctions;

public class BsfEngine
extends BSFEngineImpl {
    private JSGlobalObject global;

    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
        try {
            this.global = JSUtil.makeEvaluator();
            BSFFunctions bsf = new BSFFunctions(mgr, (BSFEngine)this);
            this.global.setMember("bsf", bsf);
            int size = declaredBeans.size();
            for (int i = 0; i < size; ++i) {
                this.declareBean((BSFDeclaredBean)declaredBeans.elementAt(i));
            }
        }
        catch (Throwable t) {
            this.handleError(t);
        }
    }

    public Object eval(String source, int lineNo, int columnNo, Object oscript) throws BSFException {
        String script = oscript.toString();
        Object retval = null;
        try {
            retval = this.global.eval(script);
        }
        catch (Throwable t) {
            this.handleError(t);
        }
        return retval;
    }

    public Object apply(String source, int lineNo, int columnNo, Object funcBody, Vector paramNames, Vector arguments) throws BSFException {
        String script = funcBody.toString();
        Object retval = null;
        try {
            int nParam = paramNames == null ? 0 : paramNames.size();
            String[] names = new String[nParam];
            Object[] values = new Object[nParam];
            for (int i = 0; i < nParam; ++i) {
                names[i] = (String)paramNames.get(i);
                values[i] = arguments.get(i);
            }
            retval = this.global.evalAsFunction(script, names, values);
        }
        catch (Throwable t) {
            this.handleError(t);
        }
        return retval;
    }

    public Object call(Object object, String method, Object[] args) throws BSFException {
        Object theReturnValue = null;
        JSObject target = this.global;
        if (object != null) {
            if (!(object instanceof JSObject)) {
                throw new BSFException("Tartget object not a JSOBject");
            }
            target = (JSObject)object;
        }
        try {
            theReturnValue = target.call(method, args);
        }
        catch (Throwable t) {
            this.handleError(t);
        }
        return theReturnValue;
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        try {
            this.global.setMember(bean.name, bean.bean);
        }
        catch (Throwable t) {
            this.handleError(t);
        }
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        try {
            this.global.removeMember(bean.name);
        }
        catch (Throwable t) {
            this.handleError(t);
        }
    }

    private void handleError(Throwable t) throws BSFException {
        String message = null;
        Throwable target = t;
        if (t instanceof JSException) {
            message = t.getLocalizedMessage();
        } else if (t instanceof RuntimeException) {
            message = "Internal Error: " + t.toString();
        } else if (t instanceof StackOverflowError) {
            message = "Stack Overflow";
        }
        if (message == null) {
            message = t.toString();
        }
        if (t instanceof Error && !(t instanceof StackOverflowError)) {
            throw (Error)t;
        }
        throw new BSFException(BSFException.REASON_OTHER_ERROR, "EcmaScript Error: " + message, target);
    }

    public JSGlobalObject getJSGlobalObject() {
        return this.global;
    }
}

