/*
 * Decompiled with CFR 0.152.
 */
package FESI.AST;

import FESI.AST.EcmaScriptTreeConstants;
import FESI.AST.EcmaScriptVisitor;
import FESI.AST.Node;
import FESI.Exceptions.ProgrammingError;
import FESI.Parser.EcmaScript;
import FESI.Parser.EcmaScriptConstants;

public abstract class SimpleNode
implements Node,
EcmaScriptConstants {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected EcmaScript parser;
    protected int line = 0;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(EcmaScript p, int i) {
        this(i);
        this.parser = p;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object jjtAccept(EcmaScriptVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(EcmaScriptVisitor visitor, Object data) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(visitor, data);
            }
        }
        return data;
    }

    public String toString() {
        return EcmaScriptTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    public void setLineNumber(int line) {
        this.line = line;
    }

    public int getLineNumber() {
        return this.line;
    }

    public void assertNoChildren() {
        if (this.jjtGetNumChildren() > 0) {
            throw new ProgrammingError("AST Should have no children");
        }
    }

    public void assertOneChild() {
        if (this.jjtGetNumChildren() != 1) {
            throw new ProgrammingError("AST Should have 1 child");
        }
    }

    public void assertTwoChildren() {
        if (this.jjtGetNumChildren() != 2) {
            throw new ProgrammingError("AST Should have 2 children");
        }
    }

    public void assertThreeChildren() {
        if (this.jjtGetNumChildren() != 3) {
            throw new ProgrammingError("AST Should have 3 children");
        }
    }

    public void assertFourChildren() {
        if (this.jjtGetNumChildren() != 4) {
            throw new ProgrammingError("AST Should have 4 children");
        }
    }
}

